<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."Rhaco.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/Snapshot.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/RequireException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/DuplicateException.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 */
class DocGenerator{
	function toXml($path){
		$list	= DocGenerator::generate($path);
		$tag		= new SimpleTag("documents");

		foreach($list as $fullpath => $class){
			$classTag	= new SimpleTag("class");
			$classTag->setParameter("id",sprintf("%s.%s",$class["package"],$class["name"]));
			$classTag->setParameter("name",$class["name"]);
			$classTag->setParameter("package",$class["package"]);
			$classTag->setParameter("parent",$class["parent"]);

			foreach($class["methods"] as $name => $args){
				$argsTag		= new SimpleTag("param",$args);
				$manualTag	= new SimpleTag("description","\n");				
				$methodTag	= new SimpleTag("function");

				$methodTag->setParameter("name",$name);
				$methodTag->addValue("\n".$argsTag->get());	
				$methodTag->addValue("\n".$manualTag->get());
				$methodTag->addValue("\n");				

				$classTag->addValue("\n".$methodTag->get());
				$classTag->addValue("\n");
				$classTag->addValue("\n");
			}
			$tag->addValue("\n".$classTag->get());
		}
		return $tag->get();
	}
	function methods($path){
		$list	= DocGenerator::generate($path);
		$array	= array();
		
		foreach($list as $fullpath => $class){
			foreach($class["methods"] as $name => $args){
				$array[] = sprintf("%s::%s%s",$class["name"],$name,$args);
			}
		}
		return $array;
	}
	function generate($path){
		$classfile	= array();
		$classsrc	= array();
		$classname	= array();
		$bool		= false;
		$list		= array();

		$snapshot = new Snapshot();
			foreach(FileUtil::getFileList($path,true) as $file){
				if(!preg_match("/(\.svn\-base)|(\.pot)|(\.po)$/",$file->fullname) &&
					preg_match("/\.php$/",$file->fullname) &&
					!preg_match("/resources/",$file->fullname) &&
					$file->originalName != "po2php"
				){
					$classfile[$file->originalName]	= $file;
					$classsrc[$file->originalName]	= File::read($file->fullname);
					require_once($file->fullname);
				}
			}
		$snapshot->close();
		
		foreach(get_declared_classes() as $class){
			if(!$bool && strtolower($class) == "rhaco"){
				$bool = true;
			}
			if($bool){
				foreach(get_class_methods($class) as $method){
					$classname[$class][$method]	= $method;
				}
			}
		}
		foreach($classsrc as $originalName => $src){
			$methods		= array();

			if(preg_match_all("/function[\s\t]+(.+?)[\s\t]*(\(.*?\))[\s\t\r\n]*\{/sm",$src,$matchs)){
				foreach($matchs[1] as $key => $func){
					if($func[0] != "_" && isset($classname[$originalName][$func])){
						$methods[$func]	= $matchs[2][$key];
					}
				}
			}
			if(sizeof($methods) > 0){
				$file	= $classfile[$originalName];
				$list[]	= array("name"=>$originalName,
								"package"=>str_replace("/",".",substr(substr($file->fullname,strlen($path)),0,(strlen($file->name) * -1)-1)),
								"parent"=>get_parent_class($originalName),
								"path"=>$file->fullname,
								"methods"=>$methods,
								);
			}
		}
		return $list;
	}
}
?>