<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotConnectionException.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class Http{
	function request($url,$method="GET",$hearder=array(),$timeout=30,$blocking=1){
		$query	= "";
		$header	= "";
		$body	= "";
		
		if(!empty($url)){
			$urlList		= parse_url($url);
			$port		= $urlList["port"];
			$host		= $urlList["host"];

			if(empty($urlList["port"])){
				$port = 80;

				if($urlList["scheme"] == "ssl" || $urlList["scheme"] == "https"){
					$port = 443;
				}
			}
			$fp	= @fsockopen($host,$port,$errorno,$errormsg,$timeout);
			
			if($fp == false || false == stream_set_blocking($fp,$blocking) || false == stream_set_timeout($fp,$timeout)){
				ExceptionTrigger::raise(new NotConnectionException(Message::_("URL [{1}] {2} {3}",$url,$errstr,$errno)));
				return false;
			}
			if(isset($urlList["query"])){
				$urlList["query"] = sprintf("?%s",$urlList["query"]);
			}
			if(empty($urlList["path"])){
				$urlList["path"] = "/";
			}
			$query .= sprintf("%s %s%s HTTP/1.1\r\n",$method,$urlList["path"],$urlList["query"]);
			$query .= sprintf("Host: %s\r\n",$host);
			$query .= sprintf("User-Agent: %s\r\n",$_SERVER["HTTP_USER_AGENT"]);

			if(isset($urlList['user']) && isset($urlList['pass'])) {
			    $query .= sprintf("Authorization: Basic %s\r\n",base64_encode(sprintf("%s:%s",$urlList["user"],$urlList["pass"])));
			}
			if(!empty($hearder) && is_array($hearder)){
				foreach($hearder as $key => $value){
					$query .= sprintf("%s: %s\r\n",$key,$value);
				}
			}
			$query .= sprintf("Connection: Close\r\n\r\n");

			Logger::debug($method.$urlList["path"].$urlList["query"]);
			fwrite($fp,$query);
			socket_set_timeout($fp,$timeout);

			while(!feof($fp) && !preg_match("/\r\n\r\n$/",$header)){
				$header .= fgets($fp,4096);
			}
			if(preg_match("/Content\-Length:[\s]+([a-f0-9]+)\r\n/i",$header,$match)){
				$length	= hexdec($match[1]);

				if($length > 0){
					$rest	= $length % 4096;
					$count	= ($length - $rest) / 4096;

					while(!feof($fp)){
						if($count-- > 0){
							$body .= fread($fp,4096);
						}else{
							$body .= fread($fp,$rest);
							break;
						}
					}
				}
			}else if(preg_match("/Transfer\-Encoding:[\s]+chunked/i",$header)){
				while(!feof($fp)){
					$bytes = fgets($fp,4096);

					if(preg_match("/^([0-9a-fA-F]+)[\s\r\n]*$/",$bytes,$match)){
						$size = hexdec($match[1]);

						if($size <= 0){
							break;
						}
						$body .= fread($fp,$size);
					}else if(!preg_match("/^[\r\n]+$/",$bytes)){
						$body .= $bytes;
					}
				}
			}else{
				while(!feof($fp)){
					$body .= fread($fp,4096);
				}
			}
		}
		fclose($fp);

		return array($header,$body);		
	}
	function body($url,$method="GET",$hearder=array(),$timeout=30){
		$result = Http::request($url,$method,$hearder,$timeout);

		if(is_bool($result) && $result == false){
			return false;
		}
		list($head,$body) = $result;
		$redirectUrl			= array();
		$httpCode			= array();

		if(!empty($head)){
			if(preg_match("/HTTP\/.+[\040](\d\d\d)/i",$head,$httpCode)){
				if($httpCode[1] != "200"){
					if($httpCode[1] == "302"){
						if(preg_match("/Location:[\040](.*)/i",$head,$redirectUrl)){
							return Http::body(preg_replace("/[\r\n]/","",$redirectUrl[1]),$method);
						}
					}
					return false;
				}
			}
		}
		return $body;		
	}
	function head($url,$hearder=array(),$timeout=30){
		$result = Http::request($url,"HEAD",$hearder,$timeout);
		if(is_bool($result) && $result == false){
			return false;
		}
		list($head) = $result;
		return $head;
	}
	function modified($url,$time,$timeout=30){
		return Http::body($url,"GET",array("If-Modified-Since"=>date("r",$time)),$timeout);
	}
	function referer(){
		if(preg_match("/:\/\//",$_SERVER["HTTP_REFERER"],$null)){
			return $_SERVER["HTTP_REFERER"];
		}
		return Rhaco::url();
	}
	function status($statuscode){
		switch($statuscode){
			case 404:
				Header::write("HTTP/1.1 404 Not Found");
				break;			
			case 500:
				Header::write("HTTP/1.1 500 Internal Server Error");
				break;
			default:
				Header::write("HTTP/1.1 200 OK");	
		}
	}
}
?>