<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/TemplateFormatter.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class Snapshot{
	var $start		= false;
	var $url			= "";
	var $variables	= array();
	var $buffer		= "";

	function Snapshot($url="",$variables=array()){
		ob_start();
		$this->start 	= true;
		$this->url		= $url;
		$this->variables	= Variable::toArray($variables);
		register_shutdown_function(array($this,'close'));
		Logger::debug(Message::_("start snapshot"));
	}
	function close(){
		if($this->start){
			ob_end_clean();
			$this->start = false;
			Logger::debug(Message::_("end snapshot"));
		}
	}
	function get(){
		if($this->start){
			$this->buffer = ob_get_contents();
			$this->close();
		}
		return $this->buffer;
	}
	function set($url="",$variables=array()){
		$path		= (!empty($url) || !empty($variables)) ? Snapshot::path($url,$variables) : Snapshot::path($this->url,$this->variables);
		$fileUtil	= new FileUtil();

		if($fileUtil->write($path,$this->get())){
			Logger::debug(Message::_("made snapshot file [{1}]",$path));
		}else{
			Logger::warning(Message::_("fails in made snapshot file [{1}]",$path));
		}
		return $this->buffer;
	}
	function exist($url="",$variables=array(),$expiryTime=0){
		$path = Snapshot::path($url,$variables);
		return (FileUtil::exist($path) && ($expiryTime == 0 || (FileUtil::getUpdateTime($path) + $expiryTime) > time()));
	}
	function read($url,$variables=array()){
		$path = Snapshot::path($url,$variables);
		if(FileUtil::exist($path)){
			Logger::debug(Message::_("read snapshot file [{1}]",$path));
			return File::read($path);
		}
		Logger::warning(Message::_("fails in read snapshot file [{1}]",$path));
		return "";
	}
	function write($url="",$variables=array()){
		$path = Snapshot::path($url,$variables);
		if(FileUtil::exist($path)){
			include($path);
			Logger::debug(Message::_("read snapshot file [{1}]",$path));
		}
	}
	function clear($url="",$variables=array()){
		$path = Snapshot::path($url,$variables);
		
		if(FileUtil::rm($path)){
			Logger::debug(Message::_("snapshot file deleted [{1}]",$path));
			return true;
		}
		Logger::debug(Message::_("fails in deletion [{1}]",$path));
		return false;
	}
	function path($url,$variables=array()){
		if($url == "" && sizeof($variables) == 0){	
			$url = Rhaco::self();
		}
		$url		= base64_encode($url.TemplateFormatter::httpBuildQuery($variables));
		return FileUtil::getFilePath(Rhaco::define("SNAPSHOT_PATH",Rhaco::path("work")),".".$url);
	}
}
?>