<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/Snapshot.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class Cache{
	function isExpiry($urls,$expiryTime=86400){
		$path = Cache::path($urls);

		if(FileUtil::isFile($path) && (FileUtil::getUpdateTime($path) + $expiryTime) > time()){
			return false;
		}
		return true;
	}
	function isFile($urls){
		return FileUtil::isFile(Cache::path($urls));
	}
	function set($urls,$source){
		$path		= Cache::path($urls);
		$fileUtil	= new FileUtil();

		if($fileUtil->write($path,$source)){
			Logger::debug(Message::_("made cache file [{1}]",$path));
		}else{
			Logger::warning(Message::_("fails in made cache file [{1}]",$path));
		}
	}
	function get($urls){
		$path	= Cache::path($urls);
		$src		= "";

		if(FileUtil::isFile($path)){
			Logger::debug(Message::_("read cache file [{1}]",$path));
			return File::read($path);
		}
		Logger::warning(Message::_("fails in read cache file [{1}]",Cache::path($urls)));
		return false;
	}
	function execute($urls,$variables=array()){
		$path	= Cache::path($urls);
		$src		= "";

		if(FileUtil::isFile($path)){
			Logger::debug(Message::_("read cache file [{1}]",$path));
			
			foreach(Variable::toArray($variables) as $key => $variable){
				global ${$key};
				${$key} = $variable;
			}
			$snapshot = new Snapshot();
			include($path);
			return $snapshot->get();
		}
		Logger::warning(Message::_("fails in read cache file [{1}]",Cache::path($urls)));
		return false;
	}
	function clear($urls){
		$path = Cache::path($urls);
		
		if(FileUtil::rm($path)){
			Logger::debug(Message::_("cache file deleted [{1}]",$path));
			return true;
		}
		Logger::debug(Message::_("fails in deletion [{1}]",$path));
		return false;
	}
	function path($urls){
		$path	= "";
		$counter	= 0;
		
		foreach(Variable::toArray($urls) as $url){
			if($counter == 0){
				$path	= preg_replace("/(.+)\?.+$/","\\1",trim($url));
				$path	= preg_replace("/[\/]+/","/",str_replace("\\","/",preg_replace("/[\~\&\:\.\s]/","-",$path)));
				
				if(empty($path)){
					$path = "null";
				}
				if(substr($path,-1) == "/"){
					$path .= "index";
				}
			}else{
				$path .= "_".preg_replace("/[^\w\d]/","",substr($url,strlen(dirname($url))));
			}
			$counter++;
		}
		$path	= FileUtil::getFilePath(Rhaco::define("CACHE_PATH",Rhaco::path("work")),$path);
		
		if(Rhaco::define("CACHE_PATH_DOT",true)){
			$pos		= strrpos($path,"/");
			$name	= substr($path,$pos+1);
			$name	= substr($name,0,1) != "." ? ".".$name : $name;
			$path	= substr($path,0,$pos)."/".$name;
		}
		return $path;
	}
	function getUpdateTime($urls){
		return FileUtil::getUpdateTime(Cache::path($urls));
	}
}
?>