<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class ExceptionBase{
	var $message			= "";
	var $target			= "";
	var $properties		= array();
	var $name			= "";

	function ExceptionBase($properties=array()){
		$this->properties	= Variable::toArray($properties);
	}
	function getMessage(){
		$propertiesize	= sizeof($this->properties);
		$message			= $this->message;

		if(preg_match_all("/\{([\d]+)\}/",$message,$matches)){
			$paramsize = sizeof($matches);

			foreach($matches[1] as $value){
				if($value <= $propertiesize){
					$paramList[] = $this->properties[$value-1];
				}
			}
			if($paramsize > $propertiesize){
				for($i=0;$i<$paramsize-$propertiesize;$i++){
					$paramList[] = "";
				}
			}
			$message	= preg_replace("/\{[\d]+\}/","%s",$message);
			$message	= vsprintf($message,$paramList);
		}
		return $message;
	}
	function getDetail(){
		return sprintf("%s (%s:%d [%s])",$this->getMessage(),$this->target["file"],$this->target["line"],date("Y/m/d H:i:s"));
	}
}
?>