<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Pager.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/CriteriaPattern.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ClassTypeException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalArgumentException.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class Criterion{
	function equal($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,1);
	}
	function notEqual($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,2);
	}
	function greater($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,3);
	}
	function greaterEquals($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,4);
	}	
	function less($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,5);
	}
	function lessEquals($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,6);
	}
	function like($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,7);
	}
	function notLike($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,8);
	}
	function ilike($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;			
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,9);
	}
	function notiLike($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;			
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,10);
	}
	function in($columnOrValueA,$columnOrValueB){
		if(!is_array($columnOrValueB) || sizeof($columnOrValueB) <= 0){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,11);
	}
	function notIn($columnOrValueA,$columnOrValueB){
		if(!is_array($columnOrValueB) || sizeof($columnOrValueB) <= 0){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,12);
	}
	function add($columnOrValueA,$columnOrValueB,$pattern=1){
		if(!Variable::isClassType(Column,$columnOrValueA)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));			
			return null;
		}
		return new CriteriaPattern($columnOrValueA,$columnOrValueB,$pattern);
	}

	function pager($pagerOrLimit,$offset=0){
		if(!Variable::isClassType(Pager,$pagerOrLimit)){
			if($pagerOrLimit > 0){
				$pagerOrLimit = new Pager(0,intval($pagerOrLimit),intval($offset));
			}else{
				ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));
				return null;
			}
		}
		return new CriteriaPattern($pagerOrLimit,null,100);
	}
	function order($column){
		if(!Variable::isClassType(Column,$column)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));
			return null;
		}
		return new CriteriaPattern($column,null,101);
	}
	function orderDesc($column){
		if(!Variable::isClassType(Column,$column)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));	
			return null;
		}
		return new CriteriaPattern($column,null,102);
	}
	function distinct($column){
		if(!Variable::isClassType(Column,$column)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));			
			return null;
		}
		return new CriteriaPattern($column,null,103);
	}
	function join($columnA,$columnB){
		if(!Variable::isClassType(Column,$columnA) || !Variable::isClassType(Column,$columnB)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));
			return null;
		}
		return new CriteriaPattern($columnA,$columnB,104);
	}
}
?>