<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilSQLite.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Column.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class ExtDbUtilSQLite extends DbUtilSQLite{
	function forward($tagDataProjectDatabase){
		$sql			= "";
		$defaultSql	= "";
		
		if(Variable::isClassType(DatabaseModel,$tagDataProjectDatabase)){
			foreach($tagDataProjectDatabase->tableList as $table){
				if(Variable::isClassType(TableModel,$table)){
					$sql			.= sprintf("DROP TABLE %s;\n",$table->getTableName());					
					$sql			.= sprintf("CREATE TABLE %s (\n",$table->getTableName());
					$columnSql	= "";
					$primarySql	= "";
					
					foreach($table->columnList as $column){
						if(Variable::isClassType(ColumnModel,$column)){
							if(!empty($columnSql)){
								$columnSql .= "\t,";
							}
							$columnSql .= sprintf("%s",$column->name);
							
							if(preg_match("/(serial)/i",$column->type)){
								$columnSql .= sprintf(" INTEGER ");
							}else if(preg_match("/(float)/i",$column->type)){
								$columnSql .= sprintf(" FLOAT");
							}else if(preg_match("/(timestamp)|(date)/i",$column->type)){
								$columnSql .= sprintf(" TIMESTAMP");
							}else if(preg_match("/(int)|(time)/i",$column->type)){
								$columnSql .= sprintf(" INTEGER");
							}else if(preg_match("/(string)|(text)|(email)|(tel)|(zip)/i",$column->type)){
								if($column->size > 16777215){
									$columnSql .= sprintf(" VARCHAR");
								}else if($column->size > 65535){
									$columnSql .= sprintf(" VARCHAR");
								}else if($column->size > 255){
									$columnSql .= sprintf(" VARCHAR");
								}else if($column->size > 0){
									$columnSql .= sprintf(" VARCHAR");
								}else{
									$columnSql .= sprintf(" TEXT");
								}
							}else if(preg_match("/(bool)/i",$column->type)){
								$columnSql .= sprintf(" BOOLEAN");
							}
							if($column->require){
								$columnSql .= sprintf(" NOT NULL");
							}
							$columnSql .= "\n";
						}
					}
					foreach($table->primaryList as $column){
						if(!empty($primarySql)){
							$primarySql .= ",";
						}
						$primarySql .= sprintf("%s",$column->name);
					}
					$sql	 .= sprintf("\t %s",$columnSql);
					if(!empty($primarySql)){
						$sql .= sprintf("\t,PRIMARY KEY(%s)\n",$primarySql);
					}
					$sql .= sprintf(");\n\n");

					foreach($table->defaultList as $defaults){
						$columnString	= "";
						$valueString		= "";		
						
						foreach($table->columnList as $column){
							if($column->type != "SERIAL"){
								$value = $column->default;
	
								foreach($defaults as $default){
									if($default->column == $column->name){
										$value = $default->value;
										break;
									}
								}
								$value = $this->_getValueString($column,$value);

								$columnString	.= sprintf(",%s",$column->name);
								$valueString		.= sprintf(",%s",$value);
							}
						}
						$defaultSql .= sprintf("insert into %s(%s) values(%s);\n",$table->getTableName(),substr($columnString,1),substr($valueString,1));
					}
				}
			}
			$sql = sprintf("%s\n\n%s",$sql,$defaultSql);
		}
		return $sql;
	}
}
?>