<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotSupportedException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class ExtDbUtil extends DbUtil{
	function ExtDbUtil($dbConnection,$new=true){
		if($dbConnection->type == "MySQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilMySQL.php")){
				$this->dbUtil = new ExtDbUtilMySQL();
			}
		}else if($dbConnection->type == "PostgreSQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilPostgreSQL.php")){
				$this->dbUtil = new ExtDbUtilPostgreSQL();
			}
		}else if($dbConnection->type == "SQLite" && substr(phpversion(),0,1) >= 5){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilSQLite.php")){
				$this->dbUtil = new ExtDbUtilSQLite();
			}
		}else if($dbConnection->type == "Oci8" && substr(phpversion(),0,1) >= 5){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtilOci8.php")){
				$this->dbUtil = new ExtDbUtilOci8();
			}
		}
		if($this->dbUtil == null){
			ExceptionTrigger::raise(new NotSupportedException(Message::_("database controler [{1}]",$dbConnection->type)));
		}else{
			$this->_open($dbConnection,$new);
		}
	}
	function forward($databaseObject){
		if($this->dbUtil != null){
			return $this->dbUtil->forward($databaseObject);
		}
		return "";
	}
}
?>