<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilBase.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class DbUtilSQLite extends DbUtilBase{
	function open($dbConnection,$new=true){
		unset($new);
		if(extension_loaded("SQLite")){
			FileUtil::mkdir(dirname($dbConnection->host));
			$this->connection = sqlite_open($dbConnection->host);
			
			if($this->connection != false){
				$this->_begin();
				$this->dbConnection = $dbConnection;				
				return true;
			}
		}
		return false;
	}
	function close(){
		$this->_commit();
		if($this->connection){
			sqlite_close($this->connection);
		}
		$this->connection = false;
	}
	function query($sql){
		if($this->connection){
			Logger::debug(Message::_("[{1}] {2}",$this->connection,$sql));
	
			$this->resourceId	= @sqlite_query($this->connection,$sql);
			$errono				= sqlite_last_error($this->connection);
			$error				= sqlite_error_string($errono);
	
			if($errono > 0){
				Logger::error(Message::_("#{1} - {2}",$errono,$error));
				return false;	
			}
			return true;
		}
		return false;
	}
	function resultset(){
		if($this->resourceId != false){
			return sqlite_fetch_array($this->resourceId);
		}
		return array();
	}
	function free(){
		if($this->resourceId != false){
			$this->resourceId = false;
		}
	}
	function _getSelectString($columnList){
		$columnString = "";
		
		foreach($columnList as $column){
			$columnAlias	= sprintf("%s",$column->column);
			$columnName	= sprintf("%s.%s",$column->table->alias,$column->column);

			if($column->type == "TIMESTAMP"){
				$columnName = sprintf("strftime(%s.%s,'%%Y/%%m/%%d %%H:%%i:%%S')",$column->table->alias,$column->column);
			}else if($column->type == "DATE"){
				$columnName = sprintf("strftime(%s.%s,'%%Y/%%m/%%d')",$column->table->alias,$column->column);
			}
			$columnString .= sprintf("%s as %s__%s,",$columnName,$column->table->alias,$columnAlias);
		}
		return substr($columnString,0,-1);
	}
	function _getValueStringFormatDate($value){
		return sprintf("'%s'",DateUtil::format($value));
	}
	function _insertId($tableObject){
		unset($tableObject);
		return sqlite_last_insert_rowid($this->connection);
	}
	function _escape($value){
		if(extension_loaded("SQLite")){
			return sqlite_escape_string($value);
		}
		return addslashes($value);
	}
}
?>