<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/Snapshot.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/UnitTest.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 */
class TestRunner{
	var $value = "";
	
	function TestRunner($path,$recursive=false){
		$list		= FileUtil::find("/Test\.php$/i",$path,Variable::getBoolean($recursive));
		$directory	= "";
		$usec		= $this->_getTime();

		foreach($list as $file){
			if($directory != $file->getDirectory()){
				$this->value .= sprintf("[%s]\n",$file->getDirectory());
				$directory = $file->getDirectory();
			}
			include_once($file->getFullname());
			eval(sprintf("new %s();",$file->getOriginalName()));

			$snapshot = new Snapshot();
			UnitTest::flush();
			$this->value .= $snapshot->get();
		}
		$eusec	= $this->_getTime() - $usec;
		$this->value .= sprintf("(%s tests)%s %d microsecond\n",sizeof($list),"TOTAL_TIME",($eusec>0)?$eusec:0);
	}
	function getValue(){
		return $this->value;
	}
	function getHtml(){
		$lines	= split("\n",$this->value);
		$values	= "";

		foreach($lines as $line){	
			$value = "";
			
			if(!empty($line)){
				if(preg_match("/^(\(.+\))([\w]+) ([\-\d]+ [\w]+)/",$line,$match)){
					$values .= sprintf("<div class=\"%s\">%s %s %s</div>\n",$match[2],$match[1],$match[2],$match[3]);
				}else if(preg_match("/^(\(.+\))([\w]+) (.*)$/",$line,$match)){
					$values .= sprintf("<div class=\"%s\">%s %s</div>%s\n",$match[2],$match[1],$match[2],$match[3]);
				}else if(preg_match("/^\[(.+)\]$/",$line,$match)){
					$values .= sprintf("<div class=\"DIRECTORY\">%s</div>\n",$match[1]);
				}else{
					$values .= $line."\n";
				}
			}
		}
		return $values;
	}
	function _getTime(){
		$time	= gettimeofday();
		return ($time["sec"].str_replace(" ","0",sprintf("%-6d",$time["usec"])));
	}
}
?>