<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/TableObjectBase.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 */
class TableObjectUtil{
	function primarysmap(&$object){
		$list	= array();
		$methods	= array();
		
		if(Variable::isClassType(TableObjectBase,$object)){
			foreach(get_class_methods($object) as $method){
				$methods[strtolower($method)] = $method;
			}
			foreach($object->primaryKey() as $column){
				$method = strtolower("get".$column->variable);
				
				if(isset($methods[$method])){
					$list[]	= call_user_func_array(array(&$object,$methods[$method]),array());
				}
			}
		}
		return implode("/",$list);
	}
	function values(&$object){
		if(Variable::isClassType(TableObjectBase,$object)){
			$display		= TableObjectUtil::listDisplay(TableObjectUtil::admin($object));
			$list		= array();
			$methodList	= array();
			$formatList	= array();
			
			foreach(get_class_methods($object) as $methodName){
				if(preg_match("/^get(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}else if(preg_match("/^format(.+)$/i",$methodName,$setter)){
					$formatList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($object->columns() as $column){
				$columnnamelower	= strtolower($column->variable);
				
				if($display === null || isset($display[$columnnamelower])){
					$method					= (isset($formatList[$columnnamelower])) ? $formatList[$columnnamelower] : $methodList[$columnnamelower];
					$list[$columnnamelower]	= (isset($methodList[$columnnamelower])) ? call_user_func_array(array(&$object,$method),array()) : "";
				}
			}
			return TableObjectUtil::displayOrder($display,$list);
		}
		return array();
	}
	function names($object){
		if(Variable::isClassType(TableObjectBase,$object)){
			$list			= array();
			$methodList		= array();
			$admin			= array();
			$verifyObject	= $object->verifyObject();
			$display			= TableObjectUtil::listDisplay(TableObjectUtil::admin($object));

			foreach(Variable::toArray(get_class_methods($verifyObject)) as $methodName){
				if(preg_match("/^named(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($object->columns() as $column){
				$columnname	= strtolower($column->variable);
				
				if($display === null || isset($display[$columnname])){
					$list[$columnname]	= (isset($methodList[$columnname])) ? call_user_func_array(array($verifyObject,$methodList[$columnname]),array()) : $column->name;
				}
			}
			return TableObjectUtil::displayOrder($display,$list);
		}
		return array();
	}
	function forms($object){
		if(Variable::isClassType(TableObjectBase,$object)){
			$verifyObject	= $object->verifyObject();
			$referenceList	= array();
			$list			= array();
			$display			= TableObjectUtil::formDisplay(TableObjectUtil::admin($object));

			foreach(Variable::toArray(get_class_methods($object)) as $methodName){
				if(preg_match("/^reference(.+)$/i",$methodName,$setter)){
					$referenceList[strtolower($setter[1])] = call_user_func_array(array($object,$methodName),array());
				}				
			}
			foreach(Variable::toArray(get_class_methods($verifyObject)) as $methodName){
				if(preg_match("/^named(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($object->columns() as $column){
				$columnname				= strtolower(substr($column->variable,0,1)).substr($column->variable,1);	
				$columnnamelower			= strtolower($column->variable);

				if($display === null || isset($display[$columnnamelower])){
					$list[$columnname]				= $column;
					$list[$columnname]->name			= (!isset($methodList[$columnnamelower])) ? call_user_func_array(array($verifyObject,$methodList[$columnnamelower]),array()) : $column->column;
					$list[$columnname]->reference		= $referenceList[$columnnamelower];
				}
			}
			return TableObjectUtil::displayOrder($display,$list);
		}
		return array();
	}
	function displayOrder($display,$list){
		if($display !== null){
			$dispList = array();

			foreach($display as $columnname){				
				if(isset($list[$columnname])){
					$dispList[$columnname] = $list[$columnname];
				}
			}
			return $dispList;
		}
		return $list;
	}
	function query($object,$query){
		if(!empty($query) && Variable::isClassType(TableObjectBase,$object)){
			$hash		= TableObjectUtil::admin($object);
			$methodList	= array();
			$fields		= null;
			$columns	= array();
			$criteria	= new Criteria();

			if(isset($hash["search_fields"])){
				$fields		= array();

				foreach(Variable::toArray($hash["search_fields"]) as $field){
					$fields[strtolower($field)] = $field;
				}
			}
			foreach(Variable::toArray(get_class_methods($object)) as $methodName){
				if(preg_match("/^column(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($methodList as $column => $method){
				if($fields === null || isset($fields[$column])){
					$columns[$column] = call_user_func_array(array($object,$method),array());
				}
			}
			foreach($columns as $column){
				$criteria->addCriteriaOr(new Criteria(Criterion::like($column,sprintf(".*%s.*",$query))));
			}
			return $criteria;
		}
		return new Criteria();
	}
	function admin($object){
		foreach(get_class_methods($object) as $methodName){
			if($methodName == "admin"){
				return call_user_func_array(array($object,"admin"),array());		
			}
		}
		return null;
	}
	function listDisplay($hash){
		if(!empty($hash) && isset($hash["list_display"])){
			$display = array();

			foreach(Variable::toArray($hash["list_display"]) as $disp){
				$disp						= strtolower($disp);
				$display[strtolower($disp)] = $disp;
			}
			return $display;
		}
		return null;
	}
	function formDisplay($hash){
		if(!empty($hash) && isset($hash["form_display"])){
			$display = array();

			foreach(Variable::toArray($hash["form_display"]) as $disp){
				$disp			= strtolower($disp);
				$display[$disp] = $disp;
			}
			return $display;
		}
		return null;
	}
}
?>