<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 */
class ContributeInstaller{
	function install($application){
		if($application == "scaffold"){
			if(FileUtil::exist(Rhaco::path("sample.php"))){
				ExceptionTrigger::raise(new DuplicateException(Rhaco::path("sample.php")));
			}else{
				FileUtil::cp(
					ContributeInstaller::path("generic/resources/scaffold/sample.php"),
					Rhaco::path()
				);
				if(!FileUtil::exist(Rhaco::templatepath("sample.html"))){
					FileUtil::cp(
						ContributeInstaller::path("generic/resources/templates/scaffold/sample.html"),
						Rhaco::templatepath()
					);
				}
			}
		}		
		if($application == "authMemberManager"){
			ApplicationInstaller::writeInitFile("setup");

			FileUtil::cp(
				ContributeInstaller::path("tag/auth/resources/member.php"),
				Rhaco::path("setup")
			);
		}
		if($application== "test"){
			ApplicationInstaller::writeInitFile("setup");
			FileUtil::mkdir(Rhaco::path("setup/tests"));
			FileUtil::cp(
				ContributeInstaller::path("util/test/resources/test.php"), 
				Rhaco::path("setup")
			);
			FileUtil::cp(
				ContributeInstaller::path("util/test/resources/SampleTest.php"), 
				Rhaco::path("setup/tests")
			);
		}
		if($application== "dbAdmin"){
			ApplicationInstaller::writeInitFile("setup");

			FileUtil::cp(
				ContributeInstaller::path("database/admin/resources/admin.php"),
				Rhaco::path("setup")
			);
		}
	}
	function path($path){
		if(substr($path,0,1) == "/"){
			$path = substr($path,1);
		}
		return constant("RHACO_DIR")."contribute/".$path;
	}
}
?>