<?php
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 */
class Rhaco{
	function define($defineName,$value=""){
		if(!defined($defineName)){
			define($defineName,$value);
		}
		return constant($defineName);
	}
	function path($fileName=""){
		$context = "";

		if(preg_match("/^\/.+/",$fileName)){
			$fileName = substr($fileName,1);
		}
		if(defined("CONTEXT_PATH")){
			$context = constant("CONTEXT_PATH");
		}
		return sprintf("%s%s",$context,$fileName);
	}
	function url($url=""){
		$path = $_SERVER["HTTP_HOST"];
		
		if(preg_match("/\/([^\/])\/.+/",$_SERVER["REDIRECT_URL"],$null)){
			$path .= "/".$null[1];
		}
		return sprintf("%s%s",Rhaco::_pathnormalize(Rhaco::define("CONTEXT_URL",$path)),Rhaco::_urlnormalize($url));
	}
	function page($pagename){
		return Rhaco::url($pagename.".php");
	}
	function self(){
		return $_SERVER["SCRIPT_NAME"];
	}
	function resource($resourceFileName){
		$resourceFileName = str_replace("\\","/",$resourceFileName);

		if(substr($resourceFileName,0,1) != "/"){
			$resourceFileName = sprintf("/%s",$resourceFileName);
		}
		return Rhaco::path(sprintf("resources%s",$resourceFileName));
	}
	function templatepath($filename=""){
		if(empty($filename)){
			return Rhaco::define("TEMPLATE_PATH");
		}
		if(substr($filename,0,1) === "/" || preg_match("/^[\w]+\:\/\//",$filename)){
			return $filename;
		}
		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
		return FileUtil::getFilePath(Rhaco::define("TEMPLATE_PATH"),$filename);
	}
	function templateurl($url=""){
		return sprintf("%s%s",Rhaco::_pathnormalize(Rhaco::define("TEMPLATE_URL")),Rhaco::_urlnormalize($url));
	}
	function import($rhacoClassName){
		$file = Rhaco::_phppathnormalize(Rhaco::define("RHACO_DIR"),$rhacoClassName);
		if(file_exists($file)){
			return require_once($file);
		}
		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
		Logger::error(Message::_("Not found {1}",$file));
		return false;
	}
	function importLibrary($fileName){
		$path = Rhaco::path("library/");

		if(defined("LIBRARY_PATH")){
			$path = Rhaco::define("LIBRARY_PATH");
		}
		$file = Rhaco::_phppathnormalize($path,$fileName);

		if(file_exists($file)){
			return require_once($file);
		}
		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
		Logger::error(Message::_("Not found {1}",$file));
		return false;
	}
	function loadLibrary($fileName){
		$path = Rhaco::path("library/");

		if(defined("LIBRARY_PATH") && !empty($fileName)){
			$path = Rhaco::define("LIBRARY_PATH");
		}
		$file = Rhaco::_phppathnormalize($path,$fileName);

		if(file_exists($file)){
			return require_once($file);
		}
		Logger::error(Message::_("Not found {1}",$file));
		return false;
	}
	function rhacoresource($resourceFileName){
		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
		return FileUtil::getFilePath(Rhaco::define("RHACO_DIR"),sprintf("resources/%s",$resourceFileName));
	}
	function setupErrorMessage(){
		Rhaco::import("resources.Message");
		return Message::_("It cannot perform with the same path as rhaco.");
	}
	function usesession($id=""){
		if(session_id() == ""){
			if(!empty($id)){
				session_id($id);
			}
			/** セッションに保存されたクラスオブジェクトの定義を先にincludeする必要があります。　*/
			/** (none/nocache/private/private_no_expire/public) */
			session_cache_limiter(Rhaco::define("SESSION_CACHE_LIMITER","nocache"));
			session_cache_expire(Rhaco::define("SESSION_EXPIRE_TIME",2592000));
			session_start();
		}
	}
	function version(){
		return "0.9.6";
	}
	function _phppathnormalize($path,$fileName){
		if(preg_match("/^(.+)\.php$/",$fileName,$null)){
			$fileName = $null[1];
		}
		return sprintf("%s%s.php",$path,str_replace(".","/",$fileName));
	}
	function _pathnormalize($path){
		if(preg_match("/[^\/]$/",$path,$null)){
			$path = $path."/";
		}
		return $path;
	}
	function _urlnormalize($url){
		if(preg_match("/^\/.+/",$url)){
			$url = substr($url,1);
		}
		return $url;
	}
}
?>
<?php
if(!defined("RHACO_DIR")){
	Rhaco::define("RHACO_DIR",Rhaco::_pathnormalize(dirname(__FILE__)));
	Rhaco::import("resources.Message");
	Rhaco::import("lang.Variable");
	Rhaco::import("util.Logger");	
	Message::loadRhacoMessages();

	$logger = new Logger();
	register_shutdown_function(array($logger,'flush'));
}
?>