<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class PersonTableVerify{
	var $valid = true;

	function PersonTableVerify(){
	}
	function verify($tableObject){
		$this->verifyId($tableObject->getId());
		$this->verifyName($tableObject->getName());
		$this->verifyAge($tableObject->getAge());
		$this->verifyFlag($tableObject->getFlag());
		$this->verifyRegistDate($tableObject->getRegistDate());
		return $this->valid;	
	}
	function verifyId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedId())),$this->_validName("id"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedId())),$this->_validName("id"));
		}
		unset($value);
	}
	function verifyName($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedName())),$this->_validName("name"));
		}
		if(!empty($value) && !Validate::isString($value,0,100)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedName(),100)),$this->_validName("name"));
		}
		unset($value);
	}
	function verifyAge($value){
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedAge())),$this->_validName("age"));
		}
		unset($value);
	}
	function verifyFlag($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedFlag())),$this->_validName("flag"));
		}
		unset($value);
	}
	function verifyRegistDate($value){
		if(!empty($value) && !Validate::isTimestamp($value)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedRegistDate())),$this->_validName("registDate"));
		}
		unset($value);
	}

	function namedId(){
		return Message::_("ID");
	}
	function namedName(){
		return Message::_("NAME");
	}
	function namedAge(){
		return Message::_("AGE");
	}
	function namedFlag(){
		return Message::_("FLAG");
	}
	function namedRegistDate(){
		return Message::_("REGIST_DATE");
	}
	function _validName($name){
		$this->valid = false;
		return "Person_".$name;
	}
}

?>