<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionRhacotest");
Rhaco::importLibrary("data.verify.PersonVerify");
Rhaco::importLibrary("data.Address");
class PersonTable extends TableObjectBase{
	var $id;
	var $name;
	var $age;
	var $flag;
	var $registDate;

	function PersonTable(
		$id=null
	){
		$this->id = 0;
		$this->name = "abc";
		$this->age = 0;
		$this->flag = 0;
		$this->registDate = time();
		$this->setId($id);
	}

	function setId($value){
		$this->id = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getId(){
		return $this->id;
	}
	function setName($value){
		$this->name = $value;
	}
	function getName(){
		return $this->name;
	}
	function setAge($value){
		$this->age = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getAge(){
		return $this->age;
	}
	function setFlag($value){
		$value = intval(Variable::getBoolean($value));
		$this->flag = $value;
	}
	function getFlag(){
		return Variable::getBoolean($this->flag);
	}
	function setRegistDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->registDate = $value;
	}
	function getRegistDate(){
		return $this->registDate;
	}
	function formatRegistDate($format="Y/m/d H:i:s"){
		return date($format,$this->registDate);
	}
	
	function columnId(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"ID","Id","SERIAL");
	}
	function columnName(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"NAME","Name","STRING");
	}
	function columnAge(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"AGE","Age","INTEGER");
	}
	function columnFlag(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"FLAG","Flag","BOOLEAN");
	}
	function columnRegistDate(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"REGIST_DATE","RegistDate","TIMESTAMP");
	}

	function __columns(){
		return array(
				$this->columnId(),
				$this->columnName(),
				$this->columnAge(),
				$this->columnFlag(),
				$this->columnRegistDate(),
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnId(),
				);
	}
	function dependColumnId(){
		return array(
				array(
					new Address(),
				),array(
					Address::columnPersonId(),
				),$this->getId());
	}
	function related($criteria=null){
		if(Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
	
		return $criteria;
	}
	function __verify(){
		$verify = new PersonVerify();
		return $verify->verify($this);
	}
	function verifyObject(){
		return new PersonVerify();
	}
	function connection(){
		return new DbConnectionRhacotest();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
			list($objList,$columnList,$value) = $this->dependColumnId();
			foreach($objList as $key => $obj){
				$dbUtil->delete($obj,new Criteria($columnList[$key],$value));
			}
		}
		unset($dbUtil,$criteria);
	}
}
?>