<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionRhacotest");
Rhaco::importLibrary("data.verify.AddressVerify");
Rhaco::importLibrary("data.Person");
class AddressTable extends TableObjectBase{
	var $personId;
	var $email;

	function AddressTable(
		$personId=null
	){
		$this->personId = 0;
		$this->email = null;
		$this->setPersonId($personId);
	}

	function setPersonId($value){
		$this->personId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getPersonId(){
		return $this->personId;
	}
	function setEmail($value){
		$this->email = StringUtil::convertZenhan($value);
	}
	function getEmail(){
		return $this->email;
	}
	
	function columnPersonId(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."ADDRESS","ADDRESS"),"PERSON_ID","PersonId","INTEGER");
	}
	function columnEmail(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."ADDRESS","ADDRESS"),"EMAIL","Email","EMAIL");
	}

	function __columns(){
		return array(
				$this->columnPersonId(),
				$this->columnEmail(),
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnPersonId(),
				);
	}
	function criteriaPersonId($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){
			$criteria = new Criteria();
		}
		$criteria->add(
			Person::columnId(),
			$this->getPersonId()
		);
		return $criteria;
	}
	function related($criteria=null){
		if(Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			Person::columnId(),
			Address::columnPersonId()
		);
	
		return $criteria;
	}
	function __verify(){
		$verify = new AddressVerify();
		return $verify->verify($this);
	}
	function verifyObject(){
		return new AddressVerify();
	}
	function connection(){
		return new DbConnectionRhacotest();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
		}
		unset($dbUtil,$criteria);
	}
}
?>