<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/TemplateFormatter.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.8.4
 */
class Header{
	function requestInline($fileOrUrl,$filename="",$contentType=""){
		if(Variable::isClassType(File,$fileOrUrl)){
			$file = $fileOrUrl;
		}else{
			$file = new File($fileOrUrl);
		}
		if(!empty($filename)){
			$name = $filename;
		}else{
			$name = $file->getName();
		}
		if(empty($contentType)){
			$contentType = "image/jpeg";
		}
		header(sprintf("Content-Type: ".$contentType."; name=%s",$name));
		header(sprintf("Content-Disposition: inline; filename=%s",$name));
		if($file->getSize() > 0){
			header(sprintf("Content-length: %u",$file->getSize()));
		}
		$file->output();
	}	
	function requestAttachment($fileOrUrl,$filename="",$contentType=""){
		if(Variable::isClassType(File,$fileOrUrl)){
			$file = $fileOrUrl;
		}else{
			$file = new File($fileOrUrl);
		}
		if(!empty($filename)){
			$name = $filename;
		}else{
			$name = $file->getName();
		}
		if(empty($contentType)){
			$contentType = "application/octet-stream";
		}
		header(sprintf("Content-Type: ".$contentType."; name=%s",$name));
		header(sprintf("Content-Disposition: attachment; filename=%s",$name));
		if($file->getSize() > 0){
			header(sprintf("Content-length: %u",$file->getSize()));
		}		
		$file->output();
	}
	function redirect(){
		$argList			= func_get_args();
		$tagFormatter	= new TemplateFormatter();
		$list			= array();
		$url				= $argList[0];

		if(is_array($argList[0])){
			$count = 0;
			
			foreach($argList[0] as $key => $value){
				if($count == 0){
					$url		= $value;
				}else{
					$list	= array_merge($list,array($key=>$value));					
				}
				$count++;
			}
		}
		for($i=1;$i<=sizeof($argList);$i++){
			$list	= array_merge($list,Variable::toArray($argList[$i]));
		}
		$requestString = call_user_func_array(array($tagFormatter,"httpBuildQuery"),Variable::toArray($list));

		if(!empty($requestString)){
			if(substr($requestString,0,1) == "?"){
				$requestString = substr($requestString,1);
			}			
			$url = sprintf("%s?%s",$url,$requestString);
		}
		Logger::debug(sprintf("Location: %s",$url));
		header(sprintf("Location: %s",$url));
	}
	function write($variable){
		if(is_array($variable)){
			foreach($variable as $key => $value){
				header(sprintf("%s: %s",$key,$value));
			}
		}else{
			header($variable);
		}
	}
}
?>