<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/PermissionException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.3
 */
class File{
	var $directory;
	var $fullname;
	var $name;
	var $originalName;
	var $extension;
	var $size;
	var $update;
	var $value;

	var $tmp;
	var $error;

	function File($fullname,$value=""){
		$this->fullname	= $fullname;
		$this->value	= $value;		
		$this->_parseFullname();
	}
	function _parseFullname(){
		$info				= @pathinfo(str_replace("\\","/",$this->fullname));
		$this->directory		= $info["dirname"];
		$this->name			= $info["basename"];
		$this->extension		= ".".$info["extension"];
		$this->originalName	= @basename($this->name,$this->extension);

		if($this->isFile()){
			$this->update	= @filemtime($this->fullname);
			$this->size		= sprintf("%u",@filesize($this->fullname));
		}
	}
	function generate($filename){
		if(@copy($this->tmp,$filename)){
			if(@unlink($this->tmp)){
				$this->fullname = $filename;
				$this->_parseFullname();

				return true;
			}
		}
		ExceptionTrigger::raise(new PermissionException($filename));		
		return false;
	}
	function isFile(){
		return is_file($this->fullname);
	}
	function move($filePath){
		if($this->copy($filePath)){
			return $this->delete();
		}
		return false;
	}
	function delete(){
		return unlink($this->fullname);
	}
	function copy($filePath){
		if(!empty($filePath)){
			if(copy($this->fullname,$filePath)){
				return true;
			}
		}
		return false;
	}
	function uptake(){
		$this->setValue(File::read($this->fullname));
		return $this->getValue();
	}
	function export(){
		return File::write($this->fullname,$this->getValue());
	}
	function output(){
		if($this->isFile() && empty($this->value)){
			readfile($this->fullname);
		}else{
			print($this->getValue());
		}
	}
	function read($filename){
		$buffer	= "";
		$fp		= @fopen($filename,"r");
		if($fp){
			while(!feof($fp)){
				$buffer .= fgets($fp,4096);
			}
			@fclose($fp);
		}else{
			ExceptionTrigger::raise(new PermissionException($filename));
		}
		return $buffer;
	}
	function write($filename,$src=""){
		$bool	= false;
		$fp		= @fopen($filename,"wb");
		if($fp){
			if(!(false === fwrite($fp,$src))){
				$bool = true;
			}
			@fclose($fp);
		}
		if(!$bool){
			ExceptionTrigger::raise(new PermissionException($filename));
		}
		return $bool;
	}
	function getDirectory(){
		return $this->directory;
	}
	function getFullname(){
		return $this->fullname;
	}
	function getName(){
		return $this->name;
	}
	function getOriginalName(){
		return $this->originalName;
	}
	function getExtension(){
		return $this->extension;
	}
	function getSize(){
		return $this->size;
	}
	function getUpdate($dateformat=""){
		if(!empty($dateformat)){
			return date($dateformat,$this->update);
		}
		return $this->update;
	}
	function getTmp(){
		return $this->tmp;
	}
	function isError(){
		return (intval($this->error) > 0);
	}
	function setValue($value){
		$this->value	= $value;
		$this->size	= sizeof($value);
	}
	function getValue(){
		return $this->value;
	}
}
?>