<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/CriteriaPattern.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Criterion.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Pager.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ClassTypeException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalArgumentException.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.8.3
 */
class Criteria{
	var $criteriaList					= array();	
	var $criteriaPatternColumnValueList	= array();
	var $criteriaPatternColumnColumnList	= array();
	var $orderList						= array();
	var $joinList						= array();
	var $distinctList					= array();	
	var $limit		= null;
	var $offset		= null;
	var $lock		= null;
	var $verifyFK	= true;
	var $unionAll	= false;
	
	function Criteria(){
		$args = func_get_args();		

		if(sizeof($args) == 2 && Variable::isClassType(Column,$args[0])){
			$this->addEqual($args[0],$args[1]);
		}else{
			foreach($args as $arg){
				foreach(Variable::toArray($arg) as $criteriaPattern){
					$this->_add($criteriaPattern);
				}
			}
		}
	}
	function setVerifyFK($boolean){
		$this->verifyFK = Variable::getBoolean($boolean);
		return $this;
	}
	function setPager($pager){
		if(Variable::isClassType(Pager,$pager)){			
			$this->setLimit($pager->limit);
			$this->setOffset($pager->offset);
		}
		return $this;
	}
	function setLimit($value){
		$this->limit = Variable::getInt($value);
		return $this;
	}
	function setOffset($value){
		$this->offset = Variable::getInt($value);
		return $this;
	}
	function setLock($value){
		$this->lock = Variable::getBoolean($value);
		return $this;
	}
	function setUnionAll($boolean=false){
		$this->unionAll = $boolean;
		return $this;
	}
	function add($columnOrValueA,$columnOrValueB){
		$this->addEqual($columnOrValueA,$columnOrValueB);
		return $this;
	}
	function addEqual($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::equal($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addNotEqual($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::notEqual($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addGreater($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::greater($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addGreaterEquals($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::greaterEquals($columnOrValueA,$columnOrValueB));
		return $this;
	}	
	function addLess($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::less($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addLessEquals($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::lessEquals($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addLike($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::like($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addNotLike($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::notLike($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addLikei($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::ilike($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addNotLikei($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::notiLike($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addIn($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::in($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addNotIn($columnOrValueA,$columnOrValueB){
		$this->_add(Criterion::notIn($columnOrValueA,$columnOrValueB));
		return $this;
	}
	function addOrder($column){
		$this->_add(Criterion::order($column));
		return $this;
	}
	function addOrderDesc($column){
		$this->_add(Criterion::orderDesc($column));
		return $this;
	}
	function addDistinct($column){
		$this->_add(Criterion::distinct($column));
		return $this;
	}
	function addJoin($columnA,$columnB){
		$this->_add(Criterion::join($columnA,$columnB));
		return $this;
	}
	function addCriteria($criteria){
		$this->_addCriteria($criteria,1);
		return $this;
	}
	function addCriteriaOr($criteria){
		$this->_addCriteria($criteria,2);
		return $this;
	}
	function _addCriteria($criteria,$pattern=1){
		if(!Variable::isClassType(Criteria,$criteria)){		
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));
		}else{
			$this->criteriaList[] = new CriteriaPattern($criteria,null,$pattern);
		}
	}

	function isLimit(){
		return ($this->limit != null);
	}
	function isOffset(){
		return ($this->offset != null);
	}
	function isLock(){
		return ($this->lock != null);
	}
	function isDistinct(){
		return (sizeof($this->distinctList) > 0);
	}	
	function isUnionAll(){
		return Variable::getBoolean($this->unionAll);
	}
	function clear(){
		$this->criteriaList					= array();	
		$this->criteriaPatternColumnValueList	= array();
		$this->criteriaPatternColumnColumnList	= array();
		$this->orderList						= array();
		$this->joinList						= array();		
		$this->limit							= null;
		$this->offset						= null;
		$this->lock							= null;
		$this->distinctList						= array();
	}
	function _add($criteriaPattern){
		if(Variable::isClassType(CriteriaPattern,$criteriaPattern)){
			if($criteriaPattern->pattern < 100){
				if($criteriaPattern->isColumn()){
					$this->criteriaPatternColumnColumnList[] = $criteriaPattern;
				}else{
					$this->criteriaPatternColumnValueList[] = $criteriaPattern;
				}
			}else if($criteriaPattern->pattern == 100){
				$this->setPager($criteriaPattern->columnOrValueA);
			}else if($criteriaPattern->pattern == 101 || $criteriaPattern->pattern == 102){
				$this->orderList[] = $criteriaPattern;
			}else if($criteriaPattern->pattern == 103){
				$this->distinctList[] = $criteriaPattern;
			}else if($criteriaPattern->pattern == 104){
				$this->joinList[] = $criteriaPattern;
			}
		}
	}
	function __tables(){
		$tables = array();

		foreach($this->criteriaPatternColumnColumnList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;
			$tables[$criteriaPattern->columnOrValueB->table->alias][$criteriaPattern->columnOrValueB->column] = $criteriaPattern->columnOrValueB;
		}
		foreach($this->criteriaPatternColumnValueList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;			
		}
		foreach($this->orderList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;			
		}
		foreach($this->criteriaList as $criteria){
			$tables = array_merge($tables,$criteria->columnOrValueA->__tables());
		}
		return $tables;
	}
}
?>