<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilPostgreSQL.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.3
 */
class ExtDbUtilPostgreSQL extends DbUtilPostgreSQL{
	function forward($tagDataProjectDatabase){
		$sql			= "";
		$defaultSql	= "";
		
		if(Variable::isClassType(DatabaseModel,$tagDataProjectDatabase)){
			foreach($tagDataProjectDatabase->tableList as $table){
				if(Variable::isClassType(TableModel,$table)){
					$sql				.= sprintf("CREATE TABLE %s (\n",$table->getTableName());
					$columnSql		= "";
					$primarySql		= "";
					$referenceSql	= "";
					
					foreach($table->columnList as $column){
						if(Variable::isClassType(ColumnModel,$column)){
							if(!empty($columnSql)){
								$columnSql .= "\t,";
							}
							$columnSql .= sprintf("%s",$column->name);

							if(preg_match("/(serial)/i",$column->type)){
								$type = "SERIAL";
								if($column->size > 9){
									$type = "BIGSERIAL";
								}
								$columnSql .= sprintf(" %s",$type);
							}else if(preg_match("/(float)/i",$column->type)){
								$columnSql .= sprintf(" DOUBLE PRECISION");
							}else if(preg_match("/(timestamp)|(date)/i",$column->type)){
								$type = "TIMESTAMP";
								$columnSql .= sprintf(" %s",$type);
							}else if(preg_match("/(int)|(time)/i",$column->type)){
								$type = "INTEGER";								
								if($column->size > 9){
									$type = "NUMERIC";
								}
								$columnSql .= sprintf(" %s",$type);
							}else if(preg_match("/(string)|(text)|(email)|(tel)|(zip)/i",$column->type)){
								if($column->size > 0){
									$type = "VARCHAR";
									$columnSql .= sprintf(" %s",$type);
									$columnSql .= sprintf("(%d)",$column->size);
								}else{
									$type = "TEXT";
									$columnSql .= sprintf(" %s",$type);
								}
							}else if(preg_match("/(bool)/i",$column->type)){
								$type = "SMALLINT";
								$columnSql .= sprintf(" %s",$type);
							}
							if($column->require){
								$columnSql .= sprintf(" NOT NULL");
							}
							$columnSql .= "\n";
						}
					}
					foreach($table->primaryList as $column){
						if(!empty($primarySql)){
							$primarySql .= ",";
						}
						$primarySql .= sprintf("%s",$column->name);
					}
					$sql	 .= sprintf("\t %s",$columnSql);
					
					if(!empty($primarySql)){
						$sql .= sprintf("\t,PRIMARY KEY(%s)\n",$primarySql);
					}
					$sql .= sprintf(");\n\n");
					
					foreach($table->defaultList as $defaults){
						$columnString	= "";
						$valueString		= "";		
						
						foreach($table->columnList as $column){
							if($column->type != "SERIAL"){
								$value = $column->default;
	
								foreach($defaults as $default){
									if($default->column == $column->name){
										$value = $default->value;
										break;
									}
								}
								$value = $this->_getValueString($column,$value);

								$columnString	.= sprintf(",%s",$column->name);
								$valueString		.= sprintf(",%s",$value);
							}
						}
						$defaultSql .= sprintf("insert into %s(%s) values(%s);\n",$table->getTableName(),substr($columnString,1),substr($valueString,1));
					}
				}
			}
			foreach($tagDataProjectDatabase->tableList as $table){
				if(Variable::isClassType(TableModel,$table)){
					foreach($table->referenceList as $reference){
						$sql .= sprintf("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);\n",
													$reference->table,
													sprintf("FK_%s_%s",$reference->table,$reference->column),
													$reference->column,
													$reference->referenceTableReal,
													$reference->referenceColumn
									);
					}
				}
			}
			$sql = sprintf("%s\n\n%s",$sql,$defaultSql);
		}
		return $sql;
	}
}
?>