<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class ContributeInstaller{
	function install($application){
		if($application == "authMemberManager" || $application== "dbAdmin"){
			ApplicationInstaller::writeInitFile("setup");

			FileUtil::cp(
				ContributeInstaller::path("tag/auth/resources/member.php"),
				Rhaco::path("setup")
			);
		}
		if($application== "test"){
			ApplicationInstaller::writeInitFile("setup");
			FileUtil::mkdir(Rhaco::path("setup/tests"));
			FileUtil::cp(
				ContributeInstaller::path("util/test/resources/test.php"), 
				Rhaco::path("setup")
			);
			FileUtil::cp(
				ContributeInstaller::path("util/test/resources/SampleTest.php"), 
				Rhaco::path("setup/tests")
			);
		}
		if($application== "dbAdmin"){
			FileUtil::mkdir(Rhaco::path("admin"));
			ApplicationInstaller::writeInitFile("admin");

			if(!FileUtil::exist(Rhaco::path("admin/create.php"))){
				FileUtil::cp(ContributeInstaller::path("database/admin/create.php"), Rhaco::path("admin"));
			}
			if(!FileUtil::exist(Rhaco::path("admin/drop.php"))){
				FileUtil::cp(ContributeInstaller::path("database/admin/drop.php"), Rhaco::path("admin"));
			}
			if(!FileUtil::exist(Rhaco::path("admin/index.php"))){
				FileUtil::cp(ContributeInstaller::path("database/admin/index.php"), Rhaco::path("admin"));
			}
			if(!FileUtil::exist(Rhaco::path("admin/list.php"))){
				FileUtil::cp(ContributeInstaller::path("database/admin/list.php"), Rhaco::path("admin"));
			}
			if(!FileUtil::exist(Rhaco::path("admin/update.php"))){
				FileUtil::cp(ContributeInstaller::path("database/admin/update.php"), Rhaco::path("admin"));
			}
			if(!FileUtil::exist(Rhaco::path("library/DbAdminConnection.php"))){
				FileUtil::cp(ContributeInstaller::path("database/admin/library/DbAdminConnection.php"), Rhaco::path("library"));
			}
		}
	}
	function path($path){
		if(substr($path,0,1) == "/"){
			$path = substr($path,1);
		}
		return constant("RHACO_DIR")."contribute/".$path;
	}
}
?>