<?php
Rhaco::import("util.UnitTest");
Rhaco::import("lang.Variable");
Rhaco::importLibrary("ClassDummy");
Rhaco::importLibrary("ClassDummyEx");
Rhaco::importLibrary("ClassDummyCopy");

class VariableTest extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testGetBoolean(){
		$this->assertTrue(Variable::getBoolean("true"));
		$this->assertTrue(Variable::getBoolean(true));		
		$this->assertTrue(Variable::getBoolean(1));
		$this->assertFalse(Variable::getBoolean("false"));
		$this->assertFalse(Variable::getBoolean(false));
		$this->assertFalse(Variable::getBoolean(-1));						
	}
	function testGetInt(){
		$this->assertEquals(123,Variable::getInt("123"));
		$this->assertEquals(123,123);
		$this->assertEquals(123,Variable::getInt("１２３"));
		$this->assertEquals(0,Variable::getInt("ＡＢＣ"));
	}
	function testToArray(){
		$this->assertEquals(array("abc"),Variable::toArray("abc"));		
		$this->assertEquals(array("abc","123"),Variable::toArray(array("abc","123")));				
	}
	function testIsClassType(){
		$this->assertTrue(Variable::isClassType("classDummy",new ClassDummy()));			
		$this->assertTrue(Variable::isClassType("CLASSDUMMY",new ClassDummy()));	
		$this->assertTrue(Variable::isClassType("classdummy",new ClassDummy()));	
		$this->assertTrue(Variable::isClassType(ClassDummy,new ClassDummy()));			
		$this->assertFalse(Variable::isClassType("dummy",new ClassDummy()));
		$this->assertTrue(Variable::isClassType("classdummy",new ClassDummyEx()));	
		$this->assertTrue(Variable::isClassType("classdummyex",new ClassDummyEx()));	
		$this->assertFalse(Variable::isClassType("dummy",new ClassDummyEx()));
	}
	function testHashConvObject(){
		$obj = new ClassDummy();
		
		$newobj = Variable::hashConvObject(array("abc"=>"A","def"=>"B","hij"=>"C"),$obj);
		
		$this->assertEquals("A",$obj->abc);
		$this->assertEquals("B",$obj->def);
		$this->assertTrue(empty($obj->hij));
		$this->assertEquals("A",$newobj->abc);
		$this->assertEquals("B",$newobj->def);
		$this->assertTrue(empty($newobj->hij));		
	}
	function testObjectConvHash(){
		$obj		= new ClassDummy();
		$obj->abc = "A";
		$obj->def = "B";
		$obj->hij = "C";

		$newhash = Variable::objectConvHash($obj);

		$this->assertEquals("A",$newhash["abc"]);
		$this->assertEquals("B",$newhash["def"]);				
		$this->assertEquals("Getter[C]",$newhash["hij"]);		
		
		$hash	= array("abc"=>"ABC","klm"=>"K");
		$newhash	= Variable::objectConvHash($obj,$hash);

		$this->assertEquals("A",$newhash["abc"]);
		$this->assertEquals("B",$newhash["def"]);
		$this->assertEquals("Getter[C]",$newhash["hij"]);
		$this->assertEquals("K",$newhash["klm"]);
		$this->assertEquals("ABC",$hash["abc"]);		
	}
	function testCopyProperties(){
		$from	= new ClassDummy();
		$to		= new ClassDummyCopy();
		
		$from->abc = "A";
		$from->def = "B";
		$from->hij = "C";
		
		$newto = Variable::copyProperties($from,$to);
		
		$this->assertEquals($from->abc,$newto->abc);
		$this->assertTrue(empty($newto->def));
		$this->assertEquals($from->getHij(),$newto->hij);
		
		$this->assertEquals($from->abc,$to->abc);
		$this->assertTrue(empty($to->def));
		$this->assertEquals($from->getHij(),$to->hij);		
	}
	function testToJson(){
		$variable = array(1,2,3);
		$this->assertEquals("[1,2,3]",Variable::toJson($variable));
		$variable = "ABC";
		$this->assertEquals("\"ABC\"",Variable::toJson($variable));				
		$variable = 10;
		$this->assertEquals("10",Variable::toJson($variable));
		$variable = 10.123;
		$this->assertEquals("10.123",Variable::toJson($variable));
		$variable = true;
		$this->assertEquals("true",Variable::toJson($variable));
		
		$variable		= new ClassDummy();
		$variable->abc = "A";
		$variable->def = "B";
		$variable->hij = "C";
		$this->assertEquals('{abc:"A",def:"B",hij:"Getter[C]"}',Variable::toJson($variable));
					
		$variable = array('foo', 'bar', array(1, 2, 'baz'), array(3, array(4)));
		$this->assertEquals('["foo","bar",[1,2,"baz"],[3,[4]]]',Variable::toJson($variable));		
	}
}
?>