<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class NetscapeBookmarkItem{
	var $title = "";
	var $link = "";
	var $description = "";
	var $modified = "";
	var $issued = "";
	var $created = "";
	var $tags = "";

	function NetscapeBookmarkItem($title="",$description="",$link=""){
		$this->setTitle($title);
		$this->setLink($link);
		$this->setDescription($description);
	}
	function set($dtvalue,$ddvalue=""){
		$intag = new SimpleTag();
		$intag->set($dtvalue,"a");

		$this->setTitle($intag->getValue());
		$this->setLink($intag->getParameter("href"));
		$this->setTags($intag->getParameter("tags"));
		$this->setCreated($intag->getParameter("add_date"));
		$this->setIssued($intag->getParameter("last_visit"));
		$this->setModified($intag->getParameter("last_modified"));

		$this->setDescription($ddvalue);
	}
	function get(){
		$src	= "<dt>";
		$tag	= new SimpleTag("a",$this->getTitle());
		$tag->setParameter("href",$this->getLink());
		$tag->setParameter("add_date",$this->getCreated());
		$tag->setParameter("last_visit",$this->getIssued());
		$tag->setParameter("last_modified",$this->getModified());
		$tag->setParameter("tags",$this->getTags());
		$src 	.= $tag->get()."\n";

		if($this->getDescription() != ""){
			$src .= "<dd>".$this->getDescription()."\n";
		}
		return $src;
	}

	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setLink($value){
		$this->link = $value;
	}
	function getLink(){
		return $this->link;
	}
	function setDescription($value){
		$this->description = $value;
	}
	function getDescription(){
		return $this->description;
	}
	function setModified($value){
		$this->modified = intval($value);
	}
	function getModified(){
		return intval($this->modified);
	}
	function setIssued($value){
		$this->issued = intval($value);
	}
	function getIssued(){
		return intval($this->issued);
	}
	function setCreated($value){
		$this->created = intval($value);
	}
	function getCreated(){
		return intval($this->created);
	}
	function setTags($value){
		if($this->tags != ""){
			$this->tags = trim($this->tags)." ";
		}
		$this->tags .= trim($value);
	}
	function getTags(){
		return $this->tags;
	}
}