<?php
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.3
 */
class DateUtil{
	function add($time,$seconds=0,$minutes=0,$hours=0,$day=0,$month=0,$year=0){
		$dateList	= getdate(intval($time));

		return mktime($dateList["hours"] + $hours,
						$dateList["minutes"] + $minutes,
						$dateList["seconds"] + $seconds,
						$dateList["mon"] + $month,
						$dateList["mday"] + $day,
						$dateList["year"] + $year
					);
	}
	function addDay($time,$add){
		return DateUtil::add($time,0,0,0,$add);
	}
	function addHour($time,$add){
		return DateUtil::add($time,0,0,$add);
	}
	function parseString($str){
		if(!empty($str)){
			if(is_string($str)){
				$str		= trim($str);
				$zonetime	= date("Z");

				if(preg_match("/Z$/i",$str)){
					$zonetime = 0;
				}else if(preg_match("/(.+)([\+\-])(\d\d)[\:]*(\d\d)$/",$str,$tmp)){
					$zonetime = (intval($tmp[3]) * 3600) + (intval($tmp[4]) * 60);
					if($tmp[2] == "-"){
						$zonetime *= -1;
					}
					$str		= $tmp[1];
				}
				if(preg_match("/(UTC)|(Jan)|(Feb)|(Mar)|(Apr)|(May)|(Jun)|(Jul)|(Aug)|(Sep)|(Oct)|(Nov)|(Dec)/i",$str)){
					$time = strtotime($str) - $zonetime;
				}else{
					$str	= preg_replace("/[^0-9]/","",$str);
					$time	= mktime(
								substr($str,8,2),					
								substr($str,10,2),								
								substr($str,12,2),					
								substr($str,4,2),
								substr($str,6,2),
								substr($str,0,4)
								) - $zonetime;
				}
				if($time > 0){
					return $time + date("Z");
				}
			}else{
				return intval($str);
			}
		}
		return -1;
	}
	function formatFull($time){
		return date("Y/m/d H:i:s (D)",intval($time));
	}
	function format($time){
		return date("Y/m/d H:i:s",intval($time));
	}
	function formatAtom($time){
		return date("Y-m-d\TH:i:s\Z",intval($time));
	}
	function formatCookie($time){
		return date("D, d M Y H:i:s T",intval($time));	
	}
	function formatISO8601($time){
		return date("Y-m-d\TH:i:sO",intval($time));
	}
	function formatRFC822($time){
		return date("D, d M Y H:i:s T",intval($time));
	}
	function formatRFC850($time){
		return date("l, d-M-y H:i:s T",intval($time));
	}
	function formatRFC1036($time){
		return date("l, d-M-y H:i:s T",intval($time));
	}
	function formatRFC1123($time){
		return date("D, d M Y H:i:s T",intval($time));
	}
	function formatRfc2822($time){
		return date("D, d M Y H:i:s O",intval($time));
	}
	function formatRss($time){
		return date("D, d M Y H:i:s T",intval($time));
	}
	function formatW3C($time){
		$tzd = date("O",intval($time));
		$tzd = $tzd[0].substr($tzd,1,2).":".substr($tzd,3,2);
		return date("Y-m-d\TH:i:s",intval($time)).$tzd;
	}
}
?>