<?php
Rhaco::import("util.UnitTest");
Rhaco::import("io.FileUtil");
Rhaco::import("tag.data.Tag");

class TagTest extends UnitTest{
	var $src;
	
	function setUp(){
		$fileUtil = new FileUtil();
		$this->src = $fileUtil->read(Rhaco::templatepath("tag/sample.xml"));
	}
    function tearDown(){
	}
	function testSet(){
		$tag = new Tag();
		$tag->set($this->src);
		
		$this->assertEquals("opml",$tag->getName());
	}
	function testSetBody(){
		$tag = new Tag();
		$tag->set($this->src,"body");
		
		$this->assertEquals($tag->getName(),"body");
	}
	function testGetIn(){
		$tag = new Tag();
		$tag->set($this->src);

		$list = $tag->getIn("outline");

		$this->assertEquals(sizeof($list),3);
		foreach($list as $intag){
			$this->assertEquals($intag->getName(),"outline");
			
			foreach($tag->getIn("outline") as $inintag){
				$this->assertEquals($inintag->getName(),"outline");
			}
		}
	}
	function testIsParameter(){
		$tag = new Tag();
		$tag->set($this->src,"outline");
		$this->assertTrue($tag->isParameter("text"));
		$this->assertFalse($tag->isParameter("value"));		
		$this->assertTrue($tag->isParameter("id"));		
	}
	function testGetParameter(){
		$tag = new Tag();
		$tag->set($this->src,"outline");
		$this->assertEquals("search",$tag->getParameter("text"));
		$this->assertEquals("test",$tag->getParameter("value","test"));		
		$this->assertEquals("",$tag->getParameter("value"));				
	}
	function testGetAttribute(){
		$tag = new Tag();
		$tag->set($this->src,"outline");
		$this->assertEquals("selected",$tag->getAttribute("selected"));
		$this->assertEquals("",$tag->getAttribute("checked"));		
	}
}
?>