<?php
Rhaco::import("util.UnitTest");
Rhaco::import("io.FileUtil");

class FileUtilTest extends UnitTest{
	function setUp(){
		$fileUtil = new FileUtil();
		$fileUtil->write(Rhaco::resource("iotest/test1.txt"),"AAA");		
		$fileUtil->write(Rhaco::resource("iotest/test2.txt"),"BBB");
		$fileUtil->write(Rhaco::resource("iotest/data1/test3.txt","CCC"));
		$fileUtil->write(Rhaco::resource("iotest/data2/test4.txt"),"DDD");
		$fileUtil->write(Rhaco::resource("iotest/data1/data3/test5.txt"),"EEE");		
	}
    function tearDown(){
		FileUtil::rm(Rhaco::resource("iotest"));
	}
	function testRead(){
		$fileUtil = new FileUtil();
		
		$file1 = $fileUtil->read(Rhaco::templatepath("test.html"));
		$file2 = "";
		
		$fp = fopen(Rhaco::templatepath("test.html"),"r");
		while(!feof($fp)){
			$file2 .= fread($fp,4096);
		}		
		$this->assertEquals($file2,$file1);
	}
	function testWrite(){
		$fileUtil = new FileUtil();

		if(is_file(Rhaco::resource("iotest/writetest"))){
			$this->assertFalse(true);
		}else{
			$fileUtil->write(Rhaco::resource("iotest/writetest"),"rhaco");
			$src = "";
					
			$fp = fopen(Rhaco::resource("iotest/writetest"),"r");
			while(!feof($fp)){
				$src .= fread($fp,4096);
			}
			fclose($fp);
			$this->assertEquals("rhaco",$src);
		}
	}
	function testAppend(){
		$fileUtil = new FileUtil();

		if(is_file(Rhaco::resource("iotest/writetest"))){
			$this->assertFalse(true);
		}else{
			$fileUtil->write(Rhaco::resource("iotest/writetest"),"rhaco");
			$fileUtil->append(Rhaco::resource("iotest/writetest"),"abc");			
			$src = "";
					
			$fp = fopen(Rhaco::resource("iotest/writetest"),"r");
			while(!feof($fp)){
				$src .= fread($fp,4096);
			}
			fclose($fp);
			$this->assertEquals("rhacoabc",$src);
		}
	}
	function testGetFilePath(){
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io/FileUtilTest.php/",FileUtil::getFilePath("/Users/kaz/Sites/rhacotest/test/io/FileUtilTest.php"));
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io/",FileUtil::getFilePath("/Users/kaz/Sites/rhacotest/test/io"));
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io/",FileUtil::getFilePath("/Users/kaz/Sites/rhacotest/test/io/"));		
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io/",FileUtil::getFilePath("\\Users\\kaz\\Sites\\rhacotest\\test\\io"));
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io/abc",FileUtil::getFilePath("/Users/kaz/Sites/rhacotest/test/io/","abc"));
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io/abc",FileUtil::getFilePath("/Users/kaz/Sites/rhacotest/test/io/","/abc"));
	}
	function testParseFilename(){
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io/FileUtilTest.php",FileUtil::parseFilename("/Users/kaz/Sites/rhacotest/test/io/FileUtilTest.php"));
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io",FileUtil::parseFilename("/Users/kaz/Sites/rhacotest/test/io"));
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io",FileUtil::parseFilename("/Users/kaz/Sites/rhacotest/test/io/"));		
		$this->assertEquals("/Users/kaz/Sites/rhacotest/test/io",FileUtil::parseFilename("\\Users\\kaz\\Sites\\rhacotest\\test\\io"));
	}
	function testExist(){
		$this->assertTrue(FileUtil::exist(Rhaco::path()));
		$this->assertTrue(FileUtil::exist(Rhaco::path("index.php")));
		$this->assertFalse(FileUtil::exist(Rhaco::path("index.error")));
	}
	function testIsFile(){
		$this->assertTrue(FileUtil::isFile(Rhaco::path("index.php")));
		$this->assertFalse(FileUtil::isFile(Rhaco::path()));		
	}	
	function testIsDir(){
		$this->assertTrue(FileUtil::isDir(Rhaco::path()));
		$this->assertFalse(FileUtil::isDir(Rhaco::path("index.php")));		
	}
	function testGetFileList(){
		$list = FileUtil::getFileList(Rhaco::resource("iotest"));
		$this->assertEquals(2,sizeof($list));
		
		$list = FileUtil::getFileList(Rhaco::resource("iotest"),true);
		$this->assertEquals(5,sizeof($list));		
	}
	function testGetDirNameList(){
		$list = FileUtil::getDirNameList(Rhaco::resource("iotest"));
		$this->assertEquals(2,sizeof($list));
		
		$list = FileUtil::getDirNameList(Rhaco::resource("iotest"),true);
		$this->assertEquals(3,sizeof($list));		
	}
	function testFind(){
		$list = FileUtil::find("test",Rhaco::resource("iotest"));
		$this->assertEquals(2,sizeof($list));
		
		$list = FileUtil::find("test1",Rhaco::resource("iotest"));
		$this->assertEquals(1,sizeof($list));
		
		$list = FileUtil::find(".txt",Rhaco::resource("iotest"));
		$this->assertEquals(2,sizeof($list));

		$list = FileUtil::find(".txt",Rhaco::resource("iotest"),true);
		$this->assertEquals(5,sizeof($list));
	}
	function testCp(){
		$fileUtil = new FileUtil();
		$fileUtil->write(Rhaco::resource("iotest/writetest"),"rhaco");
		
		$src1 = $fileUtil->read(Rhaco::resource("iotest/writetest"));		
		FileUtil::cp(Rhaco::resource("iotest/writetest"),Rhaco::resource("iotest/data1"));
		$src2 = $fileUtil->read(Rhaco::resource("iotest/data1/writetest"));		

		$this->assertEquals($src1,$src2);
	}
	function testRm(){
		$this->assertTrue(is_file(Rhaco::resource("iotest/data2/test4.txt")));
		$this->assertTrue(is_dir(Rhaco::resource("iotest/data2")));

		$this->assertTrue(FileUtil::rm(Rhaco::resource("iotest/data2/test4.txt")));		
		$this->assertTrue(!is_file(Rhaco::resource("iotest/data2/test4.txt")));
		
		$this->assertTrue(FileUtil::rm(Rhaco::resource("iotest/data2")));
		$this->assertTrue(!is_dir(Rhaco::resource("iotest/data2")));		
	}
	function testMkdir(){
		$this->assertTrue(!is_dir(Rhaco::resource("iotest/data6")));				
		$this->assertTrue(FileUtil::mkdir(Rhaco::resource("iotest/data6")));
		$this->assertTrue(is_dir(Rhaco::resource("iotest/data6")));				
		
		$this->assertTrue(!is_dir(Rhaco::resource("iotest/data6/data7/data8/data9")));				
		$this->assertTrue(FileUtil::mkdir(Rhaco::resource("iotest/data6/data7/data8/data9")));
		$this->assertTrue(is_dir(Rhaco::resource("iotest/data6/data7/data8/data9")));						
	}
	function testMv(){
		$fileUtil = new FileUtil();
			
		$this->assertTrue(is_file(Rhaco::resource("iotest/data2/test4.txt")));
		$src1 = $fileUtil->read(Rhaco::resource("iotest/data2/test4.txt"));
		
		$this->assertTrue(FileUtil::mv(Rhaco::resource("iotest/data2/test4.txt"),Rhaco::resource("iotest/data1/test6.txt")));		
		$src2 = $fileUtil->read(Rhaco::resource("iotest/data1/test6.txt"));
		$this->assertEquals($src1,$src2);
		
		$this->assertTrue(FileUtil::mv(Rhaco::resource("iotest/data1/test6.txt"),Rhaco::resource("iotest/data4/test7.txt")));				
		$src3 = $fileUtil->read(Rhaco::resource("iotest/data4/test7.txt"));
		$this->assertEquals($src2,$src3);

	}
	function testTransaction(){
		$fileUtil = new FileUtil();
		$fileUtil->setTransaction(true);

		$src1 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));
		$fileUtil->fwrite(Rhaco::resource("iotest/data2/test4.txt"),"ABC");
		$src2 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));
		$fileUtil->rollback(Rhaco::resource("iotest/data2/test4.txt"));
		$src3 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));
		$fileUtil->fputs(Rhaco::resource("iotest/data2/test4.txt"),"DEF");
		$src4 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));		
		
		$fileUtil->close();
		
		$this->assertEquals($src2,"ABC");		
		$this->assertEquals($src1,$src3);	
		$this->assertEquals($src4,"DDDDEF");			
	}
	function testTransactionUnit(){
		$fileUtil = new FileUtil();
		$fileUtil->setTransaction(true);
		
		$srcA1 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));	
		$srcB1 = $fileUtil->fgets(Rhaco::resource("iotest/test2.txt"));
		
		$fileUtil->fwrite(Rhaco::resource("iotest/data2/test4.txt"),"ABC");
		$srcA2 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));							

		$fileUtil->rollback(Rhaco::resource("iotest/data2/test4.txt"));
		$srcA3= $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));					

		$fileUtil->fwrite(Rhaco::resource("iotest/test2.txt"),"abc");
		$srcB2 = $fileUtil->fgets(Rhaco::resource("iotest/test2.txt"));		

		$fileUtil->rollback(Rhaco::resource("iotest/test2.txt"));
		$srcB3 = $fileUtil->fgets(Rhaco::resource("iotest/test2.txt"));					

		$fileUtil->fwrite(Rhaco::resource("iotest/test2.txt"),"abc");
		$srcB4 = $fileUtil->fgets(Rhaco::resource("iotest/test2.txt"));				

		$fileUtil->fwrite(Rhaco::resource("iotest/data2/test4.txt"),"ABC");
		$fileUtil->commit(Rhaco::resource("iotest/data2/test4.txt"));
		$srcA4 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));		

		$fileUtil->rollback(Rhaco::resource("iotest/data2/test4.txt"));
		$srcA5 = $fileUtil->fgets(Rhaco::resource("iotest/data2/test4.txt"));
		
		$fileUtil->rollback(Rhaco::resource("iotest/test2.txt"));
		$srcB5 = $fileUtil->fgets(Rhaco::resource("iotest/test2.txt"));
		
		$fileUtil->close(Rhaco::resource("iotest/data2/test4.txt"));
		$fileUtil->close(Rhaco::resource("iotest/test2.txt"));
				
		$this->assertEquals("DDD",$srcA1);
		$this->assertEquals("ABC",$srcA2);
		$this->assertEquals("DDD",$srcA3);
		$this->assertEquals("ABC",$srcA4);
		$this->assertEquals("ABC",$srcA5);
		
		$this->assertEquals("BBB",$srcB1);
		$this->assertEquals("abc",$srcB2);
		$this->assertEquals("BBB",$srcB3);
		$this->assertEquals("abc",$srcB4);
		$this->assertEquals("BBB",$srcB5);
	}
}
?>