<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."Rhaco.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/RequireException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/DuplicateException.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
class ReferenceGenerator{
	var $htmlParser;
	var $request;
	var $fileUtil;

	function ReferenceGenerator(){
		$this->fileUtil		= new FileUtil();
		$this->htmlParser 	= new HtmlParser();
		$this->tagUtil 		= new TagUtil();
		$this->request		= new Request();

		if($this->request->isPost()){
			if($this->request->isVariable("create")){
				$this->_createXml();
			}else if($this->request->isVariable("generate")){
//				$this->_generatePhp();
			}else if($this->request->isVariable("marge")){
//				$this->_marge();
			}
			$this->htmlParser->write(Rhaco::rhacoresource("templates/setup/done.html"));
		}else{
			$this->htmlParser->write(Rhaco::rhacoresource("templates/setup/reference.html"));
		}

	}
	function _createXml(){
		$pathstrlen	= strlen(Rhaco::path());
		$tag		= new Tag("reference");
		$tag->addValue("\n");
		
		foreach($this->fileUtil->getFileList(Rhaco::path(),true) as $file){
			if(preg_match("/(\.php)$/",$file->fullname)){
				$src	= $this->fileUtil->read($file->fullname);
				$intag	= new Tag("class");
				$intag->addValue("\n");
				$list	= array();

				if(preg_match("/class (.+)[\s\r\n]*{/",$src,$match)){
					$list["pakage"]		= str_replace("/",".",substr($file->directory,$pathstrlen));
					$list["class"]		= $match[1];					
					$list["extends"]	= "";
					$list["method"]		= array();

					if(preg_match("/(.+) extends (.+)/",$list["class"],$match)){
						$list["class"]		= $match[1];
						$list["extends"]	= $match[2];						
					}
					if(preg_match_all("/function ([^_].*)[\s\r\n]*{/",$src,$match)){
						foreach($match[1] as $value){
							$method			= array();
							list($method["name"],$args) = explode("(",$value,2);

							if(strlen($args) > 1){
								$method["arg"] = substr($args,0,-1);								
							}
							$list["method"][] = $method;
						}
					}
					$intag->addParameterValue("name",$list["class"]);
					$intag->addParameterValue("pakage",$list["pakage"]);
					$intag->addParameterValue("extends",$list["extends"]);

					$datatag = new Tag("description");
					$intag->addValue($datatag->get()."\n");

					foreach($list["method"] as $method){
						$datatag	= new Tag("method");
						$datatag->addParameterValue("name",$method["name"]);

						$datatag->addValue("\n");

						$dataintag = new Tag("arg",$method["arg"]);
						$datatag->addValue($dataintag->get()."\n");

						$dataintag = new Tag("description");
						$datatag->addValue($dataintag->get()."\n");

						$dataintag = new Tag("result");
						$datatag->addValue($dataintag->get()."\n");												

						$intag->addValue($datatag->get()."\n");
					}
					$tag->addValue($intag->get()."\n");
					$tag->addValue("\n");
				}
			}
		}
		$this->fileUtil->write(Rhaco::path("setup/reference/reference.xml"),$tag->get(),"UTF-8");
	}
}
?>