<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."Rhaco.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/RequireException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/DuplicateException.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.1
 */
class PotGenerator{
	var $htmlParser;
	var $tagUtil;
	var $request;
	var $memberfile;
	var $fileUtil;

	function PotGenerator(){		
		$this->fileUtil		= new FileUtil();
		$this->htmlParser 	= new HtmlParser();
		$this->tagUtil 		= new TagUtil();
		$this->request		= new Request();

		if($this->request->isPost()){
			if($this->request->isVariable("create")){
				$this->_createPot();
			}else if($this->request->isVariable("generate")){
				$this->_generatePhp();
			}else if($this->request->isVariable("marge")){
				$this->_marge();
			}
			$this->htmlParser->write(Rhaco::rhacoresource("templates/setup/done.html"));
		}else{
			$this->htmlParser->write(Rhaco::rhacoresource("templates/setup/po2php.html"));
		}
	}
	function _escape($value){
		$value	= trim($value);
		$value	= str_replace("\r","\\r",$value);
		$value	= str_replace("\n","\\n",$value);
		
		return $value;
	}	
	function _createPot(){
		$messageList	= $this->_massageList();
		$outoutsrc	= $this->_header();
				
		foreach($messageList as $message => $fileList){
			foreach($fileList as $fileline){
				$outoutsrc .= sprintf("%s\n",$fileline);
			}
			$outoutsrc .= "\n";
			$outoutsrc .= sprintf("msgid \"%s\"\n",$message);
			$outoutsrc .= sprintf("msgstr \"\"\n");
			$outoutsrc .= "\n";
		}
		$this->fileUtil->write(Rhaco::path("setup/po/message.pot"),$outoutsrc,"UTF-8");
	}
	function _massageList(){
		$messageList	= array();
		$pathstrlen	= strlen(Rhaco::path());

		foreach($this->fileUtil->getFileList(Rhaco::path(),true) as $file){
			if(!preg_match("/(\.svn\-base)|(\.pot)|(\.po)$/",$file->fullname)){
				$src			= $this->fileUtil->read($file->fullname);
				$lineList	= explode("\n",$src);
					
				foreach($lineList as $lineNo => $line){
					while(preg_match("/_\(([\"\'])(.+?)\\1/",$line,$matche)){
						if(!isset($messageList[$matche[2]])){
							$messageList[$matche[2]] = array();
						}
						$messageList[$matche[2]][] = sprintf("#: %s:%d",substr($file->fullname,$pathstrlen),$lineNo+1);
						$line = str_replace($matche[0],"",$line);
					}
				}
			}
		}
		if($this->fileUtil->exist(Rhaco::path("setup/project.xml"))){
			$tag		= new Tag();
			$src		= $this->fileUtil->read(Rhaco::path("setup/project.xml"));
			
			if($tag->set($src,"project")){
				foreach($tag->getIn("database") as $databaseTag){
					foreach($databaseTag->getIn("description") as $valueTag){
						$messageList[$this->_escape($valueTag->getValue())][] = sprintf("#: setup/project.xml:database");
					}
				}
				foreach($tag->getIn("input") as $inputTag){
					foreach($inputTag->getIn("description") as $valueTag){
						$messageList[$this->_escape($valueTag->getValue())][] = sprintf("#: setup/project.xml:input");
					}
					foreach($inputTag->getIn("title") as $valueTag){
						$messageList[$this->_escape($valueTag->getValue())][] = sprintf("#: setup/project.xml:input");
					}
				}
				foreach($tag->getIn("select") as $inputTag){
					foreach($inputTag->getIn("description") as $valueTag){
						$messageList[$this->_escape($valueTag->getValue())][] = sprintf("#: setup/project.xml:input");
					}
					foreach($inputTag->getIn("title") as $valueTag){
						$messageList[$this->_escape($valueTag->getValue())][] = sprintf("#: setup/project.xml:input");
					}
					foreach($inputTag->getIn("data") as $valueTag){
						$messageList[$this->_escape($valueTag->getValue())][] = sprintf("#: setup/project.xml:input");
					}
				}
			}
		}
		return $messageList;
	}
	function _header(){
		$outoutsrc	= "";
		$outoutsrc	.= "# SOME DESCRIPTIVE TITLE.\n";
		$outoutsrc	.= "# Copyright (C) YEAR THE PACKAGE'S COPYRIGHT HOLDER\n";
		$outoutsrc	.= "# This file is distributed under the same license as the PACKAGE package.\n";
		$outoutsrc	.= "# FIRST AUTHOR <EMAIL@ADDRESS>, YEAR.\n";
		$outoutsrc	.= "#\n";
		$outoutsrc	.= "#, fuzzy\n";
		
		$outoutsrc	.= "msgid \"\"\n";
		$outoutsrc	.= "msgstr \"\"\n";
		$outoutsrc	.= "\"Project-Id-Version: PACKAGE VERSION\\n\"\n";
		$outoutsrc	.= "\"Report-Msgid-Bugs-To: \\n\"\n";
		$outoutsrc	.= sprintf("\"POT-Creation-Date: %s\\n\"\n",date("Y-m-d H:iO"));
		$outoutsrc	.= "\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n\"\n";
		$outoutsrc	.= "\"Last-Translator: FULL NAME <EMAIL@ADDRESS>\\n\"\n";
		$outoutsrc	.= "\"Language-Team: LANGUAGE <team@exsample.com>\\n\"\n";
		$outoutsrc	.= "\n";
		
		return $outoutsrc;
	}
	function _marge(){
		$file			= $this->request->getFile("pofile");
		
		if($file->isError()){
			ExceptionTrigger::raise(new RequireException(Message::_("Attached file")));
		}else{
			$filename		= sprintf("%s.pot",substr($file->name,0,(strlen($file->extension) * -1)));		
			$pomessageList	= $this->_pofileMessageList();
			$messageList		= $this->_massageList();
			$outoutsrc		= $this->_header();
					
			foreach($messageList as $message => $fileList){
				foreach($fileList as $fileline){
					$outoutsrc .= sprintf("%s\n",$fileline);
				}
				$outoutsrc .= "\n";
				$outoutsrc .= sprintf("msgid \"%s\"\n",$message);
				$outoutsrc .= sprintf("msgstr \"%s\"\n",$pomessageList[$message]);
				$outoutsrc .= "\n";
			}
			$this->fileUtil->write(Rhaco::path(sprintf("setup/po/%s",$filename)),$outoutsrc,"UTF-8");
		}
	}
	function _pofileMessageList(){
		$file		= $this->request->getFile("pofile");
		$src			= $this->fileUtil->read($file->tmp);
		$lineList	= explode("\n",$src);
		$messageList	= array();
		$msgId		= "";
		$isId		= false;

		foreach($lineList as $line){
			if(!preg_match("/^[\s]*#/",$line)){
				if(preg_match("/msgid[\s]+([\"\'])(.+)\\1/",$line,$match)){
					$msgId	= $match[2];
					$isId	= true;
				}else if(preg_match("/msgstr[\s]+([\"\'])(.+)\\1/",$line,$match) && $isId){
					$messageList[$msgId]	= $match[2];
					$isId				= false;
				}else if(preg_match("/([\"\'])(.+)\\1/",$line,$match)){
					if($isId){
						$msgId .= $match[2];
					}else{
						$messageList[$msgId] .= $match[2];
					}
				}
			}
		}
		return $messageList;	
	}
	function _generatePhp(){
		$outoutsrc	= "";
		$file		= $this->request->getFile("pofile");

		if($file->isError()){
			ExceptionTrigger::raise(new RequireException(Message::_("Attached file")));
		}else{
			$filename	= sprintf("%s.php",substr($file->name,0,(strlen($file->extension) * -1)));
			
			foreach($this->_pofileMessageList() as $key => $value){
				if(!empty($key)){
					$outoutsrc .= sprintf("\$GLOBALS[\"M\"][\"%s\"] = \"%s\";\n",$key,str_replace("\"","\\\"",$value));
				}
			}
			$this->fileUtil->write(Rhaco::resource(sprintf("locale/messages/%s",$filename)),sprintf("<?php\n%s?>",$outoutsrc),"UTF-8");
		}
	}
}
?>