<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.3.1
 */
class Request{
	var $variables	= array();
	var $session		= array();	
	var $files		= array();
	var $urlmaps		= array();	
	var $post		= false;
	
	function Request($variables=array()){
		Rhaco::usesession();
		$this->reset();
		
		if(is_array($_FILES)){
			foreach($_FILES as $key => $files){
				$this->files[$key] = $this->_parseFileElement($files);
			}
		}
		if(is_array($_SESSION)){
			foreach($_SESSION as $key => $session){
				$this->session[$key] = Variable::getMagicQuotesOffValue($session);
			}
		}
		if(is_array($_COOKIE)){
			foreach($_COOKIE as $key => $cookie){
				$this->session[$key] = Variable::getMagicQuotesOffValue($cookie);
			}
		}
		if(is_array($_POST) && sizeof($_POST) > 0){
			$this->post = true;
			
			foreach($_POST as $key => $post){
				$this->variables[$key] = Variable::getMagicQuotesOffValue($post);
			}
		}
		if(is_array($_GET)){
			foreach($_GET as $key => $get){
				$this->variables[$key] = Variable::getMagicQuotesOffValue($get);
			}
		}
		if(is_array($variables)){
			foreach($variables as $key => $value){
				$this->variables[$key] = Variable::getMagicQuotesOffValue($value);
			}
		}
		$this->variables["args"] = preg_replace("/(.*?)\?.+/","\\1",substr($_SERVER["REQUEST_URI"],strlen($_SERVER["SCRIPT_NAME"])));
		$this->setUrlMap();
		$this->validate();
	}
	function reset(){
	}
	function validate(){
	}
	function isPost(){
		if($this->post || $_SERVER["REQUEST_METHOD"] == "POST"){
			return true;
		}
		return false;
	}
	function getFile($name=""){
		if(empty($name)){
			return $this->files;			
		}
		if(!isset($this->files[$name])){
			$requestFiles			= array();
			$requestFiles['name']		= $name;
			$requestFiles['error']	= UPLOAD_ERR_NO_FILE;

			return $this->_parseFileElement($requestFiles);
		}
		return $this->files[$name];
	}
	function isFile($name){
		return Variable::isClassType(File,$this->files[$name]);
	}
	function isSession($name){
		return array_key_exists($name,$this->session);
	}
	function getSession($name="",$defaultData=""){
		if(empty($name)){
			return $this->session;
		}
		if($this->session[$name] == null){
			return $defaultData;
		}
		return $this->session[$name];
	}
	function setSession(){
		$argList = func_get_args();

		if(is_array($argList[0])){
			foreach($argList[0] as $key => $value){
				$this->session[$key] = $value;
				$_SESSION[$name] = $value;
			}
		}else{
			$this->session[$argList[0]]	= $argList[1];
			$_SESSION[$argList[0]]		= $argList[1];
		}
	}
	function clearSession(){
		if(func_num_args() == 0){
			$this->session = array();
			unset($_SESSION);
		}else{
			foreach(func_get_args() as $name){
				unset($this->session[$name]);
				unset($_SESSION[$name]);
			}
		}
	}
	function isVariable($name){
		return array_key_exists($name,$this->variables);
	}
	function getVariable($name="",$defaultData=""){
		if(empty($name)){
			return $this->variables;
		}
		if(!isset($this->variables[$name])){
			return $defaultData;
		}
		return $this->variables[$name];
	}
	function setVariable(){
		$argList = func_get_args();

		if(is_array($argList[0])){
			foreach($argList[0] as $key => $value){
				$this->variables[$key] = $value;
			}
		}else{
			$this->variables[$argList[0]] = $argList[1];
		}
	}
	function clearVariable(){
		if(func_num_args() == 0){
			$this->variables = array();
		}else{
			foreach(func_get_args() as $name){
				unset($this->variables[$name]);
			}
		}
	}
	function setUrlMap(){
		if(!empty($this->variables["args"])){
			$list			= explode("/",substr($this->variables["args"],1));
			$hash			= array();
			$this->urlmaps	= array();
			$args			= func_get_args();
			
			if(sizeof($args) == 0){
				for($i=0;$i<sizeof($list);$i++){
					$hash[] = $i;
				}
			}else{
				foreach($args as $arg){
					if(is_array($arg)){
						foreach($arg as $value){
							$hash[] = $value;
						}
					}else{
						$hash[] = $arg;
					}
				}
			}
			foreach($list as $key => $value){
				if(isset($hash[$key])){
					$key = $hash[$key];
				}
				$this->urlmaps[$key] = $value;
			}
		}
	}
	function getUrlMap(){
		if(func_num_args() == 0){
			return Variable::toArray($this->urlmaps);
		}
		list($key) = func_get_args();
		if(isset($this->urlmaps[$key])){
			return $this->urlmaps[$key];
		}
		return null;
	}
	function _parseFileElement($requestFiles){
		$fileElement			= new File($requestFiles['name']);
		$fileElement->tmp	= $requestFiles['tmp_name'];
		$fileElement->size	= $requestFiles['size'];
		$fileElement->error	= $requestFiles['error'];

		return $fileElement;
	}
	function toObject(&$object){
		return Variable::hashConvObject($this->getVariable(),$object);
	}
	function parseObject($object){
		foreach(Variable::objectConvHash($object) as $key => $value){
			$this->setVariable($key,$value);
		}
	}
}
?>