<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
class Mail{
	var $head;
	var $body;
	var $subject;
	var $from;
	var $fromName;
	var $to;
	var $cc;
	var $bcc;
	var $replyTo;
	var $errorTo;
	var $returnPath;
	var $xMailer = "Mail ver. 1.02";
	var $xMailer = "";
	var $mime = "1.0";
	var $boundary;

	var $attachedFile = array();
	var $attachedHtml = array();

	var $CONTENT_TYPE_HTML = "text/html";
	var $CONTENT_TYPE_TEXT = "text/plain";

	function pillarMail(){
	}
	
	/**
	 * @version 20041027
	 */
	function analysisMail($mailText){
		$mailText = pillarDataString::encoding($mailText,"SJIS");

		$this->analysisBody($mailText);

		$this->analysisSubject($this->head);
		$this->analysisFrom($this->head);
		$this->analysisTo($this->head);
		$this->analysisReplyTo($this->head);
		$this->analysisReturnPath($this->head);
	}
	
	/**
	 * @version 20041027
	 */
	function analysisBody($mailText){
		$this->analysisBoundary($mailText);

		list($this->head,$body) = spliti("content-type",$mailText,2);

		$bodyArray = split("--".$this->boundary,"content-type".$body);

		foreach($bodyArray as $body){
			list($head,$body) = explode("\n\n",$body,2);

			if(eregi("Content-type: *([^;\n]+)",$head,$contentsType)){
				$contentsType = strtolower($contentsType[1]);

				if($contentsType == "multipart/mixed"){
				}else if($contentsType == $this->CONTENT_TYPE_TEXT){
					$this->body = pillarDataString::encoding($body,"SJIS");
				}else{
					$structAtachedFile = new pillarDataMailAttachedFile;

					if(eregi("name=\"?([^\"\n]+)\"?",$head,$filename)){
						$structAtachedFile->filename = ereg_replace("[\t\r\n]", "",$filename[1]);

						if(eregi("(.*)=\?iso-2022-jp\?B\?([^\?]+)\?=(.*)",$structAtachedFile->filename,$filename)){
							$structAtachedFile->filename = $filename[1].base64_decode($filename[2]).$filename[3];
						}
					}
					$structAtachedFile->filename = pillarDataString::encoding($structAtachedFile->filename,"SJIS");
					$structAtachedFile->contents = base64_decode(str_replace("\n","",$body));

					array_push($this->attachedFile,$structAtachedFile);
				}
			}
		}
	}
	function analysisSubject($mailText){
		if(eregi("\nSubject:[ \t]*([^\n]+)", $mailText,$subjectArray)){
			$subject = $subjectArray[1];

			while(eregi("(.*)=\?iso-2022-jp\?B\?([^\?]+)\?=(.*)",$subject,$regs)){
				$subject = $regs[1].base64_decode($regs[2]).$regs[3];
			}
			while(eregi("(.*)=\?iso-2022-jp\?Q\?([^\?]+)\?=(.*)",$subject,$regs)){
				$subject = $regs[1].quoted_printable_decode($regs[2]).$regs[3];
			}
	    }
		$this->subject = pillarDataString::encoding($subject,"SJIS");
	}
	function analysisBoundary($mailText){
		$this->boundary = uniqid("");

		if(eregi("\nContent-type:.*multipart/",$mailText)){
			if(eregi('boundary="([^"]+)"', $mailText, $boundArray)){
				$this->boundary = $boundArray[1];
			}
		}
	}
	function analysisFrom($mailText){
		if(eregi("From:[ \t]*([^\n]+)",$mailText,$fromArray)){
			$this->from = $this->parthEmail($fromArray[1]);
		}
	}
	function analysisTo($mailText){
		if(eregi("To:[ \t]*([^\n]+)",$mailText,$fromArray)){
			$this->to = $this->parthEmail($fromArray[1]);
		}
	}
	function analysisReplyTo($mailText){
		if(eregi("Reply-To:[ \t]*([^\n]+)",$mailText,$replyToArray)){
			$this->replayPath = $this->parthEmail($replyToArray[1]);
		}
	}
	function analysisReturnPath($mailText){
		if(eregi("Return-Path:[ \t]*([^\n]+)",$mailText,$returnPathArray)){
			$this->returnPath = $this->parthEmail($returnPathArray[1]);
		}
	}
	
	/**
	 * @version 20041027
	 */
	function send($language="ja"){
		$subject	= "";
		$body		= "";
		$head		= "";

		if(sizeof($this->attachedFile) > 0 || sizeof($this->attachedHtml) > 0){
			if(empty($this->boundary)){
				$this->boundary = "----=_MultiPart_".uniqId("auto");
			}
			$headers["Content-Type"]	= "multipart/mixed; boundary=\"".$this->boundary."\"";

			if(sizeof($this->attachedHtml) > 0){
				$boundary = "----=_MultiPartHtml_".uniqId("auto");

				$body .= "This is a multi-part message in MIME format.\n";
				$body .= "--".$this->boundary."\n";
				$body .= "Content-Type: multipart/alternative; boundary=\"".$boundary."\"\n";
				$body .= "\n\n";

				$body .= "--".$boundary."\n";
				$body .= "Content-Type: text/plain; charset=\"iso-2022-jp\"\n";
				$body .= "Content-Transfer-Encoding: 7bit\n";
				$body .= "\n";
				$body .= $this->body;
				$body .= "\n";

				foreach($this->attachedHtml as $attachedFile){
					$body .= "--".$boundary."\n";

					$body .= "Content-Type: text/html; charset=\"iso-2022-jp\"\n";
					$body .= "Content-Transfer-Encoding: 7bit\n";
					$body .= "\n";

					$attachedFile->contents = str_replace("\0","",$attachedFile->contents);

					//UTF-8 BOM�Ή�
					if(ord($attachedFile->contents[0]) == 239  &&
						ord($attachedFile->contents[1]) == 187  &&
						ord($attachedFile->contents[2]) == 191
					){
						$attachedFile->contents = substr($attachedFile->contents,2);
					}
					$body .= $attachedFile->contents;
				}
				$body .= "\n";
				$body .= "--".$boundary."--\n";
				$body .= "\n";
			}else{
				$body .= "--".$this->boundary."\n";
				$body .= "Content-Type: text/plain; charset=\"iso-2022-jp\"\n";
				$body .= "Content-Transfer-Encoding: 7bit\n";
				$body .= $this->body;
				$body .= "\n";
			}
			if(sizeof($this->attachedFile) > 0){
				foreach($this->attachedFile as $attachedFile){
					$body .= "--".$this->boundary."\n";
					$body .= "Content-Type: ".$attachedFile->type."; name=\"".$attachedFile->filename."\n";
					$body .= "Content-Transfer-Encoding: base64\n";
					$body .= "Content-Disposition: attachment; filename=\"".$attachedFile->filename."\"\n";
					$body .= chunk_split(base64_encode($attachedFile->contents));
					$body .= "\n";
				}
			}
			$body .= "--" .$this->boundary ."--\n";
		}else{
			$headers["Content-Type"]				= "text/plain; charset=\"ISO-2022-JP\"";
			$headers["Content-Transfer-Encoding"]	= "7bit";
			$body .= $this->body;
		}

		if(!empty($this->cc)){		$headers["Cc"]					= $this->cc;			}
		if(!empty($this->bcc)){		$headers["Bcc"]					= $this->bcc;			}
		if(!empty($this->replyTo)){	$headers["Reply-To"]			= $this->replayTo;		}
		if(!empty($this->errorTo)){	$headers["Errors-To"]			= $this->errorTo;		}
		if(!empty($this->mime)){	$headers["Mime-Version"]		= $this->mime;			}
		if(!empty($this->xMailer)){	$headers["X-Mailer"]			= $this->xMailer;		}

		if(!empty($this->fromName)){
			if(mb_detect_encoding($this->fromName) != 'ASCII'){
				$this->fromName = mb_encode_mimeheader($this->fromName);
			}
			$headers["From"]	= sprintf("\"%s\" <%s>",$this->fromName,$this->from);
		}else{
			$headers["From"]	= $this->from;
		}

		if(!empty($headers["Reply-To"])){		$head .= sprintf("Reply-To: %s\n",$headers["Reply-To"]);		}
		if(!empty($headers["Errors-To"])){		$head .= sprintf("Errors-To: %s\n",$headers["Errors-To"]);		}
		if(!empty($headers["X-Mailer"])){		$head .= sprintf("X-Mailer: %s\n",$headers["X-Mailer"]);		}
		if(!empty($headers["From"])){			$head .= sprintf("From: %s\n",$headers["From"]);				}
		if(!empty($headers["Mime-Version"])){	$head .= sprintf("Mime-Version: %s\n",$headers["Mime-Version"]);	}
		if(!empty($headers["Content-Type"])){	$head .= sprintf("Content-Type: %s\n",$headers["Content-Type"]);	}
		if(!empty($headers["Content-Transfer-Encoding"])){	$head .= sprintf("Content-Transfer-Encoding: %s\n",$headers["Content-Transfer-Encoding"]);	}
		if(!empty($headers["Cc"])){				$head .= sprintf("cc: %s\n",$headers["cc"]);					}
		if(!empty($headers["Bcc"])){			$head .= sprintf("bcc: %s\n",$headers["bcc"]);					}

		if(preg_match("/.*\.exe$/i",$_SERVER["SCRIPT_FILENAME"])){
			$body = str_replace("\n","\r\n",str_replace("\r","",$body));
		}else{
			$body = str_replace("\r","",$body);
		}

		$subject	= mb_encode_mimeheader(preg_replace("[\r\n]","",$this->subject));
		$this->body	= pillarDataString::encoding($body,"JIS",$language);
		$returnPath	= "";
		
		if(!empty($this->returnPath)){
			$returnPath = sprintf(" -f%s",$this->returnPath);
		}
		return mail($this->to,$subject,$this->body,$head,$returnPath);
	}
	function parthEmail($email){
		if(eregi("[-!#$%&\"\'*+\\./0-9A-Z^_`a-z{|}~]+@[-!#$%&\'\"*+\\/0-9=?A-Z^_`a-z{|}~]+\.[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+", $email,$emailArray)){
			return str_replace("\"","",$emailArray[0]);
		}
		return "";
	}
	function stdin(){
		$buffer = "";

		$stdin = fopen("php://stdin","r") or die("Cannot access");
		while(!feof($stdin)){
			$buffer .= fgets($stdin,4096);
		}
		fclose($stdin);

		return $buffer;
	}
	function addAttachment($contents,$filename,$type){
		if(empty($filename)){	$filename	= uniqid("auto");				}
		if(empty($type)){		$type	= "application/octet-stream";	}

		$structAtachedFile				= new pillarDataMailAttachedFile;
		$structAtachedFile->filename	= ereg_replace("[\t\r\n]", "",$filename);
		$structAtachedFile->contents	= $contents;
		$structAtachedFile->type		= $type;

		if(strtolower($structAtachedFile->type) == $this->CONTENT_TYPE_HTML){
			array_push($this->attachedHtml,$structAtachedFile);
		}else{
			array_push($this->attachedFile,$structAtachedFile);
		}
	}
}
?>