<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilBase.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
class DbUtilOci8 extends DbUtilBase{
	function open($dbConnection,$new=true){
		if(extension_loaded("oci8")){
			$host = sprintf("%s:1521",$dbConnection->host);

			if($dbConnection->port != ""){
				$host = sprintf("%s:%d",$dbConnection->host,$dbConnection->port);
			}
			$host = sprintf("//%s/%s",$host,$dbConnection->name);

			if($new){
				$this->connection = oci_new_connect($dbConnection->user,$dbConnection->password,$host);
			}else{
				$this->connection = oci_connect($dbConnection->user,$dbConnection->password,$host);
			}
			if($this->connection != false){
				$this->_begin();
				$this->dbConnection = $dbConnection;				
				return true;
			}
		}
		return false;
	}
	function close(){
		$this->_commit();
		if($this->connection){
			oci_close($this->connection);
		}
		$this->connection = false;
	}
	function query($sql){
		if($this->connection){
			Logger::debug(Message::_("[{1}] {2}",$this->connection,$sql));

			$this->resourceId	= oci_execute(oci_parse($this->connection,$sql),OCI_DEFAULT);
			$error				= oci_error($this->connection);
	
			if(!empty($error)){
				Logger::error(Message::_("#{1} - {2}",$error));
				return false;	
			}
			return true;
		}
		return false;
	}
	function resultset(){
		if($this->resourceId != false){
			return oci_fetch_array($this->resourceId);
		}
		return array();
	}
	function free(){
		if($this->resourceId != false){
			oci_free_statement($this->resourceId);
		}
	}
	function insert($tableObject){
		$columnString	= "";
		$tableString		= "";
		$valueString		= "";
		$sql				= "";
		$isserial		= false;

		foreach($tableObject->__columns() as $columnObject){
			if($columnObject->type == "SERIAL"){
				$isserial = true;
				
				$columnString	.= sprintf(",%s",$columnObject->column);
				$valueString		.= sprintf(",%s_%s_sq.NEXTVAL",$columnObject->table->name,$columnObject->column);
				$tableString		= $columnObject->table->name;
			}else{
				$columnString	.= sprintf(",%s",$columnObject->column);
				$valueString		.= sprintf(",%s",$this->_getColumnValueString($tableObject,$columnObject));
				$tableString		= $columnObject->table->name;
			}
		}
		$sql = sprintf("insert into %s(%s) values(%s)",$tableString,substr($columnString,1),substr($valueString,1));		
		
		if($this->query($sql)){
			if($isserial){
				$lastId		= $this->_insertId($tableObject);

				if(intval($lastId) > 0){
					foreach($tableObject->__columns() as $columnObject){
						if($columnObject->type == "SERIAL"){
							call_user_func_array(array(&$tableObject,sprintf("set%s",$columnObject->variable)),array($lastId));
							break;
						}
					}
				}
			}
			return $tableObject;
		}
		return false;
	}
	function select($tableObjectList,$criteria){
		$sql							= "";		
		list($tableList,$columnList)	= $this->_getTableColumnList($tableObjectList,$criteria);

		if($criteria->isDistinct()){
			$selectString = $this->_getDistinct($tableList,$criteria);
		}else{
			$selectString = $this->_getSelectString($columnList);				
		}	
		$orderString	= $this->_getCriteriaOrder($criteria);
		$fromString		= $this->_getFromString($this->_parseCriteriaTable($tableList,$criteria),$criteria);
		$whereString	= $this->_getWhere($this->_getWhereSelect($criteria));
		$limitString	= $this->_getLimitString($criteria);
					
		if(!empty($limitString) && !empty($whereString)){
			$limitString = sprintf(" AND %s",$limitString);
		}
		$sql = sprintf("select %s from %s %s %s",
						$selectString,
						$fromString,
						$whereString,
						$limitString					
				);
		if(!empty($orderString)){
			$sql .= sprintf(" ORDER BY %s",$orderString);
		}
		$sql .= $this->_getLockString($criteria);

		return $this->query($sql);
	}
	function _getSelectString($columnList){
		$columnString = "";
		
		foreach($columnList as $column){
			$columnAlias	= sprintf("%s",$column->column);
			$columnName	= sprintf("%s.%s",$column->table->alias,$column->column);

			if($column->type == "TIMESTAMP"){
				$columnName = sprintf("TO_DATE(%s.%s,'YYYY/MM/DD HH24:MI:SS')",$column->table->alias,$column->column);
			}else if($column->type == "DATE"){
				$columnName = sprintf("TO_DATE(%s.%s,'YYYY/MM/DD')",$column->table->alias,$column->column);
			}
			$columnString .= sprintf("%s as %s__%s,",$columnName,$column->table->alias,$columnAlias);
		}
		return substr($columnString,0,-1);
	}
	function _getLimitString($criteria){
		if($criteria->isLimit()){
			return sprintf(" ROWNUM > %d AND ROWNUM < %d ",$criteria->offset,($criteria->offset + $criteria->limit));
		}
		return;
	}
	function _insertId($tableObject){
		foreach($tableObject->__primaryKey() as $pkeyColumn){
			if($this->query(sprintf("select %s_%s_sq.currval from dual",$pkeyColumn->table->name,$pkeyColumn->column))){
				$resultset = $this->resultset();	
				$this->free();
				return $resultset["CURRVAL"];
			}
		}
		return 0;
	}
	function _getValueStringFormatDate($value){
		return sprintf("TO_DATE('%s','YYYY/MM/DD HH24:MI:SS')",DateUtil::format($value));
	}
	function _escape($value){
		return addslashes($value);
	}
	function rollback(){
		oci_rollback($this->connection);
	}
	function _begin(){
	}
	function _commit(){
		oci_commit($this->connection);
	}	
}
?>