<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/DbConnection.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Criteria.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalStateException.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class DbUtilBase{
	var $resourceId		= false;
	var $connection		= false;
	var $dbConnection	= null;
		
	function open($dbConnection,$new=true){
		unset($dbConnection,$new);
		return false;
	}
	function close(){
		$this->connection = false;
	}
	function query($sql){
		unset($sql);
		return false;
	}
	function resultset(){
		return array();
	}
	function free(){
	}
	function commit(){
		$this->_commit();
		$this->_begin();		
	}
	function rollback(){
		$this->query("ROLLBACK");
	}
	function _begin(){
		$this->query("BEGIN");
	}
	function _commit(){
		$this->query("COMMIT");
	}
	function parseResultset($resultset){
		$list	= array();
		$count	= 0;		
		
		foreach($resultset as $key => $value){
			if($count % 2 == 1){
				$list[strtoupper($key)] = Variable::getMagicQuotesOffValue($value);
			}
			$count++;
		}
		return $list;
	}
	function _getTableColumnList($tableObjectList,$criteria){
		$columnList		= array();
		$tableList		= array();

		foreach($tableObjectList as $tableObject){
			foreach($tableObject->__columns() as $columnObject){
				$bool = true;

				if($criteria->isDistinct()){
					if($columnObject->column == $criteria->distinct->column &&
						$columnObject->table->alias == $criteria->distinct->table->alias
					){
						$bool = false;
					}
				}
				if($bool){
					$columnList[$this->_getColumnAliasName($columnObject)]	= $columnObject;
				}
				$tableList[$columnObject->table->alias]	= $columnObject->table;
			}
		}
		return array($tableList,$columnList);		
	}
	function _getColumnAliasName($columnObject){
		return $columnObject->table->alias."__".$columnObject->column;
	}
	function _parseCriteriaTable($tableList,$criteria){
		foreach($criteria->__tables() as $columnObjectList){
			foreach($columnObjectList as $columnObject){
				$tableList[$columnObject->table->alias]	= $columnObject->table;
			}
		}
		return $tableList;
	}
	function _getCriteriaOrder($criteria){
		$orderString = "";
		
		foreach($criteria->orderList as $criteriaPattern){
			$pattern = "ASC";
			
			if($criteriaPattern->pattern == 2){
				$pattern = "DESC";
			}
			$orderString .= sprintf(",%s %s",$this->_getColumnAliasName($criteriaPattern->columnOrValueA),$pattern);
		}
		return substr($orderString,1);
	}
	function _getSelectString($columnList){
		$columnString = "";
		
		foreach($columnList as $key => $column){
			$columnAlias	= sprintf("%s",$column->column);
			$columnName	= sprintf("%s.%s",$column->table->alias,$column->column);
			$columnString .= sprintf("%s as %s,",$columnName,$key);
		}
		return substr($columnString,0,-1);
	}
	function _getDistinct(&$tableList,$criteria){
		$columnString = "";
		
		foreach($criteria->distinctList as $distinct){
			$tableList[$distinct->table->alias]	= $distinct->table;
			$columnString .= sprintf("%s.%s as %s__%s,",
								$distinct->table->alias,
								$distinct->column,
								$distinct->table->alias,
								$distinct->column							
						);
		}
		return sprintf("DISTINCT %s",substr($columnString,0,-1));
	}
	function _getSelectCountString($columnList){
		foreach($columnList as $column){
			return sprintf("%s.%s",$column->table->alias,$column->column);
		}
		return "*";
	}

	function _getFromString($fromTableList,$criteria){
		$fromString		= "";
		
		$joinTableList	= array();
		$parentList		= array();
		$exsistTable		= array();
		$tableList		= array();
				
		foreach($criteria->joinList as $criteriaPattern){
			if(isset($exsistTable[$criteriaPattern->columnOrValueB->table->alias])){
				ExceptionTrigger::raise(new IllegalStateException(
											sprintf("%s:%s",
												$criteriaPattern->columnOrValueA->table->alias,
												$criteriaPattern->columnOrValueB->table->alias
											)
										)
					);
			}else{
				$joinTableList[$criteriaPattern->columnOrValueA->table->alias]	= $criteriaPattern;
				$tableList[$criteriaPattern->columnOrValueA->table->alias]		= true;
				$tableList[$criteriaPattern->columnOrValueB->table->alias]		= true;
				$exsistTable[$criteriaPattern->columnOrValueB->table->alias]	= true;
			}
		}
		foreach($fromTableList as $table){
			if(!isset($tableList[$table->alias])){
				$fromString .= sprintf("%s %s,",$table->name,$table->alias);
			}
		}
		foreach($joinTableList as $alias => $criteriaPattern){
			if(isset($joinTableList[$criteriaPattern->columnOrValueB->table->alias])){
				$parentList[$alias] = $criteriaPattern;
			}
		}
		foreach($parentList as $criteriaPattern){
			$joinString = sprintf("(%s %s LEFT JOIN %s %s ON %s.%s = %s.%s),",
								$criteriaPattern->columnOrValueA->table->name,
								$criteriaPattern->columnOrValueA->table->alias,
								$criteriaPattern->columnOrValueB->table->name,
								$criteriaPattern->columnOrValueB->table->alias,
								$criteriaPattern->columnOrValueA->table->alias,
								$criteriaPattern->columnOrValueA->column,
								$criteriaPattern->columnOrValueB->table->alias,
								$criteriaPattern->columnOrValueB->column
							);
			$parent		= $criteriaPattern->columnOrValueB->table->alias;
			unset($joinTableList[$criteriaPattern->columnOrValueA->table->alias]);

			while(isset($joinTableList[$parent])){
				$joinString = sprintf("(%s LEFT OUTER JOIN %s %s ON %s.%s = %s.%s),",
									substr($joinString,0,-1),
									$joinTableList[$parent]->columnOrValueB->table->name,
									$joinTableList[$parent]->columnOrValueB->table->alias,
									$joinTableList[$parent]->columnOrValueA->table->alias,
									$joinTableList[$parent]->columnOrValueA->column,
									$joinTableList[$parent]->columnOrValueB->table->alias,
									$joinTableList[$parent]->columnOrValueB->column
								);
				$parent		= $joinTableList[$parent]->columnOrValueB->table->alias;
				unset($joinTableList[$parent]);
			}
			$fromString .= $joinString;
		}
		foreach($joinTableList as $criteriaPattern){
			$joinString = sprintf("(%s %s LEFT OUTER JOIN %s %s ON %s.%s = %s.%s),",
								$criteriaPattern->columnOrValueA->table->name,
								$criteriaPattern->columnOrValueA->table->alias,
								$criteriaPattern->columnOrValueB->table->name,
								$criteriaPattern->columnOrValueB->table->alias,
								$criteriaPattern->columnOrValueA->table->alias,
								$criteriaPattern->columnOrValueA->column,
								$criteriaPattern->columnOrValueB->table->alias,
								$criteriaPattern->columnOrValueB->column
							);
			$fromString .= $joinString;
		}
		return substr($fromString,0,-1);
	}	
	function _getLimitString($criteria){
		if($criteria->isLimit()){
			return sprintf(" LIMIT %d,%d ",$criteria->offset,$criteria->limit);
		}
		return;
	}
	function _getLockString($criteria){
		if($criteria->isLock()){
			return " FOR UPDATE";
		}
		return;
	}
	function select($tableObjectList,$criteria){
		$sql							= "";		
		list($tableList,$columnList)	= $this->_getTableColumnList($tableObjectList,$criteria);

		if($criteria->isDistinct()){
			$selectString = $this->_getDistinct($tableList,$criteria);
		}else{
			$selectString = $this->_getSelectString($columnList);				
		}	
		$orderString	= $this->_getCriteriaOrder($criteria);
		$fromString		= $this->_getFromString($this->_parseCriteriaTable($tableList,$criteria),$criteria);
				
		$sql = sprintf("select %s from %s %s",
						$selectString,
						$fromString,
						$this->_getWhere($this->_getWhereSelect($criteria))
				);
		if(!empty($orderString)){
			$sql .= sprintf(" ORDER BY %s",$orderString);
		}
		$sql .= $this->_getLimitString($criteria);
		$sql .= $this->_getLockString($criteria);

		return $this->query($sql);
	}
	function count($tableObjectList,$criteria){
		list($tableList,$columnList)	= $this->_getTableColumnList($tableObjectList,$criteria);

		$selectString	= $this->_getSelectCountString($columnList);
		$fromString	= $this->_getFromString($this->_parseCriteriaTable($tableList,$criteria),$criteria);
		$sql		= sprintf("select count(%s) as count from %s %s",
							$selectString,
							$fromString,
							$this->_getWhere($this->_getWhereSelect($criteria))
						);
		if($this->query($sql)){
			$resultset = $this->resultset();	
			$this->free();
			return $resultset["count"];
		}
		return 0;
	}
	function insert($tableObject){
		$columnString	= "";
		$tableString		= "";
		$valueString		= "";
		$sql				= "";
		$isserial		= false;

		foreach($tableObject->__columns() as $columnObject){
			if($columnObject->type == "SERIAL"){
				$isserial = true;
			}else{
				$columnString	.= sprintf(",%s",$columnObject->column);
				$valueString		.= sprintf(",%s",$this->_getColumnValueString($tableObject,$columnObject));
				$tableString		= $columnObject->table->name;
			}
		}
		$sql = sprintf("insert into %s(%s) values(%s)",$tableString,substr($columnString,1),substr($valueString,1));		
		
		if($this->query($sql)){
			if($isserial){
				$lastId		= $this->_insertId($tableObject);

				if(intval($lastId) > 0){
					foreach($tableObject->__columns() as $columnObject){
						if($columnObject->type == "SERIAL"){
							call_user_func_array(array(&$tableObject,sprintf("set%s",$columnObject->variable)),array($lastId));
							break;
						}
					}
				}
			}
			return $tableObject;
		}
		return false;
	}
	function _insertId($tableObject){
		unset($tableObject);
		return 0;
	}	
	function update($tableObject,$criteria){
		$columnString	= "";
		$tableString		= "";
		$sql				= "";
		$primaryList	= array();
		
		foreach($tableObject->__primaryKey() as $columnObject){
			$primaryList[sprintf("%s_%s",$columnObject->table->name,$columnObject->column)] = $columnObject;
		}	
		foreach($tableObject->__columns() as $columnObject){
			if(empty($primaryList[sprintf("%s_%s",$columnObject->table->name,$columnObject->column)])){
				$columnString	.= sprintf(",%s = %s",$columnObject->column,$this->_getColumnValueString($tableObject,$columnObject));
				$tableString		= $columnObject->table->name;
			}
		}
		$sql = sprintf("update %s set %s %s",
									$tableString,
									substr($columnString,1),
									$this->_getWhere($this->_getWhereUpdate($tableObject,$criteria))
				);
		return $this->query($sql);
	}
	function delete($tableObject,$criteria=null){
		$tableString		= "";
		$sql				= "";

		foreach($tableObject->__columns() as $columnObject){
			$tableString		= $columnObject->table->name;
			break;
		}
		$sql = sprintf("delete from %s %s",$tableString,$this->_getWhere($this->_getWhereUpdate($tableObject,$criteria)));
		
		return $this->query($sql);
	}
		
	function _getCriteriaPatternString($pattern){
		switch($pattern){
			case 1:	return " = ";
			case 2:	return " <> ";
			case 3:	return " > ";
			case 4:	return " >= ";
			case 5:	return " < ";
			case 6:	return " <= ";
		}
		return "";
	}
	function _getWhere($whereString){
		if(!empty($whereString)){
			if(preg_match("/^ AND(.+)$/",$whereString,$value)){
				$whereString = $value[1];
			}
			return sprintf(" where %s",$whereString);
		}
		return "";
	}
	function _getWherePatternColumnValue($criteriaPattern,$alias=true){
		$columnName = $criteriaPattern->columnOrValueA->column;

		if($alias){
			$columnName = sprintf("%s.%s",$criteriaPattern->columnOrValueA->table->alias,
											$criteriaPattern->columnOrValueA->column);
		}
		if($criteriaPattern->pattern <= 6){
			return sprintf(" AND %s %s %s ",
							$columnName,
							$this->_getCriteriaPatternString($criteriaPattern->pattern),
							$this->_getValueString($criteriaPattern->columnOrValueA,$criteriaPattern->columnOrValueB)
						);
		}else if($criteriaPattern->pattern == 7 || $criteriaPattern->pattern == 8){
			return sprintf(" AND %s %s LIKE('%s') ",
								$columnName,
								(($criteriaPattern->pattern == 8)?"NOT":""),
								$this->_getWhereLikeString($criteriaPattern->columnOrValueB)
						);
		}else if($criteriaPattern->pattern == 9 || $criteriaPattern->pattern == 10){
			return sprintf(" AND LOWER(%s) %s LIKE('%s') ",
								$columnName,
								(($criteriaPattern->pattern == 10)?"NOT":""),
								$this->_getWhereLikeString(strtolower($criteriaPattern->columnOrValueB))
						);
		}else if($criteriaPattern->pattern == 11 || $criteriaPattern->pattern == 12){
			$inString	= "";

			foreach($criteriaPattern->columnOrValueB as $value){
				$inString .= sprintf(",%s",$this->_getValueString($criteriaPattern->columnOrValueA,$value));
			}
			return sprintf(" AND %s %s IN(%s) ",
							$columnName,
							(($criteriaPattern->pattern == 12)?"NOT":""),
							substr($inString,1)
						);
		}
		return;
	}
	function _getWhereSelect($criteria){
		$whereString = "";

		foreach($criteria->criteriaPatternColumnValueList as $criteriaPattern){
			$whereString .= $this->_getWherePatternColumnValue($criteriaPattern);
		}
		foreach($criteria->criteriaPatternColumnColumnList as $criteriaPattern){
			$whereString .= sprintf(" AND %s.%s %s %s.%s ",
										$criteriaPattern->columnOrValueA->table->alias,
										$criteriaPattern->columnOrValueA->column,
										$this->_getCriteriaPatternString($criteriaPattern->pattern),
										$criteriaPattern->columnOrValueB->table->alias,
										$criteriaPattern->columnOrValueB->column
								);
		}
		foreach($criteria->criteriaList as $criteriaObject){
			$pattern		= "AND";
			$where		= $this->_getWhereSelect($criteriaObject->columnOrValueA);

			if($criteriaObject->pattern == 2){
				$pattern = "OR";
			}
   			if(preg_match("/^ AND(.+)$/",$where,$value)){
				$where = $value[1];
			}
			if(!empty($where)){
				if(empty($whereString)){
					$pattern = "";
				}
				$whereString .= sprintf(" %s (%s) ",$pattern,$where);
			}
		}
		return $whereString;
	}
	function _getWhereUpdate($tableObject,$criteria){
		$whereString = "";
		$tableString = "";

		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		foreach($tableObject->__columns() as $columnObject){
			$tableString	= $columnObject->table->name;
			break;
		}
		foreach($criteria->criteriaPatternColumnValueList as $criteriaPattern){
			if($criteriaPattern->columnOrValueA->table->name == $tableString){
				$whereString .= $this->_getWherePatternColumnValue($criteriaPattern,false);
			}else{
				ExceptionTrigger::raise(new IllegalStateException(Message::_("only [{1}]",$tableString)));				
			}
		}
		return $whereString;
	}
	function _getColumnValueString($tableObject,$column){
		$value = call_user_func_array(array($tableObject,sprintf("get%s",$column->variable)),array());

		return $this->_getValueString($column,$value);
	}
	function _getValueStringFormatDate($value){
		return sprintf("DATE_FORMAT('%s','%%Y/%%m/%%d %%H:%%i:%%S')",DateUtil::format($value));
	}
	function _escape($value){
		return addslashes($value);
	}
	function _getWhereLikeString($value){
		$value = str_replace(".","_",str_replace(".*","%",$value));
		return $value;
	}
	function _getValueString($column,$value){
		$value	= $this->_escape($value);
		$type	= strtoupper($column->type);

		if(empty($value)){
			switch($type){
				case "SERIAL":
					return 0;
				case "INTEGER":
				case "FLOAT":
				case "BOOLEAN":
				case "TIME":
					if($value == null){
						return "NULL";
					}
					return 0;
				default:
					return "NULL";
			}
		}
		switch($type){
			case "EMAIL":
			case "STRING":
			case "TEXT":
			case "TEL":
			case "ZIP":
				return sprintf("'%s'",$value);
			case "INTEGER":
			case "SERIAL":
			case "TIME":			
				return intval($value);
			case "FLOAT":
				return floatval($value);
			case "DATE":
			case "TIMESTAMP":
				return $this->_getValueStringFormatDate($value);
			case "BOOLEAN":
				return intval(Variable::getBoolean($value));
			default:
		}
		return "NULL";
	}
}
?>