<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class Logger{
	function flush(){
		$fileUtil			= new FileUtil();
		$masterlevel["disp"]	= Rhaco::define("LOG_DISP_LEVEL","none");
		$masterlevel["file"]	= Rhaco::define("LOG_FILE_LEVEL","none");
		$masterlevel["sys"]	= Rhaco::define("LOG_DISP_HTML","none");
		$logpath				= Rhaco::define("LOG_FILE_PATH",Rhaco::path("work"));		
		$dipshtml			= Rhaco::define("LOG_DISP_HTML","false");

		foreach($masterlevel as $key => $value){
			$loglevel			= strtolower($value);
			$masterlevel[$key]	= 0;
			
			if($loglevel == "error"){
				$masterlevel[$key] = 1;
			}else if($loglevel == "warning"){
				$masterlevel[$key] = 2;
			}else if($loglevel == "info"){
				$masterlevel[$key] = 3;
			}else if($loglevel == "debug"){
				$masterlevel[$key] = 4;
			}
		}
		if(is_array($GLOBALS["LOGGER"]) && 
			($masterlevel["disp"] > 0 || $masterlevel["file"] > 0 || $masterlevel["sys"] > 0)
		){
			foreach($GLOBALS["LOGGER"] as $log){
				$loglevel	= "none";
				$level		= 0;
				
				if(preg_match("/^\[([\w]+) /",$log,$match)){
					$loglevel = strtolower($match[1]);
				}
				if($loglevel == "error"){
					$level = 1;
				}else if($loglevel == "warning"){
					$level = 2;
				}else if($loglevel == "info"){
					$level = 3;
				}else if($loglevel == "debug"){
					$level = 4;
				}				
				if($masterlevel["file"] >= $level){
					$fileUtil->append(sprintf("%s/%s.log",FileUtil::getFilePath($logpath,"log"),date("Ymd")),$log);
				}
				if($masterlevel["sys"] >= $level){
					if($logLevel == 1){
						syslog(LOG_ERR,$log);
					}else if($logLevel == 2){
						syslog(LOG_WARNING,$log);						
					}else if($logLevel == 3){
						syslog(LOG_INFO,$log);
					}else if($logLevel == 4){
						syslog(LOG_DEBUG,$log);
					}
				}
				if($masterlevel["disp"] >= $level){
					if($dipshtml){
						$log = nl2br(htmlspecialchars($log,ENT_QUOTES));
					}
					print($log);
				}
			}
		}
		$GLOBALS["LOGGER"] = array();
	}
	function format($level,$target,$value){
		return sprintf("[%s %s]:[%s:%d] %s\n",$level,date("Y/m/d H:i:s"),$target["file"],$target["line"],$value);
	}
	function error($value){
		list($target) = debug_backtrace();
		$GLOBALS["LOGGER"][] = Logger::format("Error",$target,$value);
	}
	function warning($value){
		list($target) = debug_backtrace();
		$GLOBALS["LOGGER"][] = Logger::format("Warning",$target,$value);
	}	
	function info($value){
		list($target) = debug_backtrace();
		$GLOBALS["LOGGER"][] = Logger::format("Info",$target,$value);
	}
	function debug($value){
		list($target) = debug_backtrace();
		$GLOBALS["LOGGER"][] = Logger::format("Debug",$target,$value);
	}
}
?>