<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssChannel.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class RssChannel10 extends RssChannel{
	var $about = "";
	
	var $imageList = array();
	var $itemsList = array();
	var $textinputList = array();

	function RssChannel10($title="",$description="",$link="",$about=""){
		parent::RssChannel($title,$description,$link);		
		$this->setAbout($about);
	}
	function _set($tag){
		parent::_set($tag);

		$this->setAbout($tag->getParameter("rdf:about"));
		
		foreach($tag->getIn("image") as $intag){
			$this->addImageList($intag->getParameter("rdf:resource"));
		}
		foreach($tag->getIn("textinput") as $intag){
			$this->addTextinputList($intag->getParameter("rdf:resource"));
		}
		foreach($tag->getIn("items") as $intag){
			foreach($intag->getIn("rdf:Seq") as $inintag){
				foreach($inintag->getIn("rdf:li") as $ininintag){
					$this->addItemsList($ininintag->getParameter("rdf:resource",$ininintag->getParameter("rdf:resource")));
				}
			}
		}		
	}
	function _get($outTag){
		$outTag = parent::_get($outTag);
		$outTag->addParameterValue("rdf:about",$this->getAbout());

		foreach($this->imageList as $value){
			$tag		= new Tag("image");
			$tag->addParameterValue("rdf:resource",$value);
			$outTag->addValue($tag->get()."\n");
		}
		foreach($this->textinputList as $value){
			$tag		= new Tag("image");
			$tag->addParameterValue("rdf:resource",$value);
			$outTag->addValue($tag->get()."\n");
		}

		$items = "";
		foreach($this->itemsList as $value){
			$tag		= new Tag("rdf:li");
			$tag->addParameterValue("resource",$value);
			$items .= $tag->get();
		}
		$tag = new Tag("rdf:Seq");
		$tag->setValue($items);
		$items = $tag->get();
		
		$tag = new Tag("items");
		$tag->setValue($items);
		$outTag->addValue($tag->get()."\n");

		return $outTag;
	}
	
	function setAbout($value){
		$this->about = $value;
	}
	function getAbout(){
		return $this->about;
	}

	function addImageList($value){
		$this->imageList[] = $value;
	}
	function getImageList(){
		return $this->imageList;
	}
	function addItemsList($value){
		$this->itemsList[] = $value;
	}
	function getItemsList(){
		return $this->itemsList;
	}
	function addTextinputList($value){
		$this->textinputList[] = $value;
	}
	function getTextinputListList(){
		return $this->textinputList;
	}
}