<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomEntry.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class AtomEntry10 extends AtomEntry{
	var $author = "";
	var $updated = "";
	var $issued = "";
	var $id = "";
	var $published = "";

	function _set($tag){
		parent::_set($tag);

		foreach($tag->getIn("author") as $intag){
			$data = new AtomAuthor();
			$data->set($intag->get());
			$this->setAuthor($data);
		}
		foreach($tag->getIn("updated") as $intag){
			$this->setUpdated($intag->getValue());
		}
		foreach($tag->getIn("issued") as $intag){
			$this->setIssued($intag->getValue());
		}
		foreach($tag->getIn("id") as $intag){
			$this->setId($intag->getValue());
		}
		foreach($tag->getIn("published") as $intag){
			$this->setPublished($intag->getValue());
		}
	}
	function _get($outTag){
		$tag		= new Tag("updated",DateUtil::formatAtom($this->getUpdated()));
		$outTag->addValue($tag->get()."\n");
		$tag		= new Tag("issued",$this->getIssued());
		$outTag->addValue($tag->get()."\n");
		$tag		= new Tag("id",$this->getId());
		$outTag->addValue($tag->get()."\n");
		$tag		= new Tag("published",$this->getPublished());
		$outTag->addValue($tag->get()."\n");

		if(Variable::isClassType(AtomAuthor,$this->getAuthor())){
			$data = $this->getAuthor();
			$outTag->addValue($data->get()."\n");
		}
				
		return parent::_get($outTag);
	}
	
	function setUpdated($value){
		$this->updated = DateUtil::parseString($value);
	}
	function getUpdated(){
		return $this->updated;
	}
	function setIssued($value){
		$this->issued = $value;
	}
	function getIssued(){
		return $this->issued;
	}
	function setPublished($value){
		$this->published = DateUtil::parseString($value);
	}
	function getPublished(){
		return $this->published;
	}
	function setId($value){
		$this->id = $value;
	}
	function getId(){
		return $this->id;
	}
	
	function setAuthor($value){
		$this->author = $value;
	}
	function getAuthor(){
		return $this->author;
	}
}