<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Atom.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomAuthor.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomLink.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomEntry10.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class Atom10 extends Atom{
	var $version = "1.0";
	var $title = "";
	var $subtitle = "";	
	var $updated = "";
	var $id = "";
	var $link = array();
	var $generator;
	var $entryList = array();
	var $author = "";

	function Atom10(){
	}
	
	function set($src){
		$tag		= new Tag();

		if(!$tag->set($src,"feed")){
			return false;
		}
		foreach($tag->getIn("entry") as $intag){
			$data = new AtomEntry03();
			$data->set($intag->get());
			$this->entryList[] = $data;
			
			$src = str_replace($intag->getPlain(),"",$src);
		}
		$src = $tag->get();		
		$tag->set($src,"feed");
		$this->setVersion($tag->getParameter("version"));

		foreach($tag->getIn("id") as $intag){
			$this->id = $intag->getValue();
		}		
		foreach($tag->getIn("title") as $intag){
			$this->title = $intag->getValue();
		}
		foreach($tag->getIn("subtitle") as $intag){
			$this->subtitle = $intag->getValue();
		}
		foreach($tag->getIn("updated") as $intag){
			$this->updated = $intag->getValue();
		}
		foreach($tag->getIn("generator") as $intag){
			$this->generator = $intag->getValue();
		}
		foreach($tag->getIn("author") as $intag){
			$author = new AtomAuthor();
			$this->author = $author->set($intag->getValue());
		}
		foreach($tag->getIn("link") as $intag){
			$data = new AtomLink();
			$data->set($intag->get());
			$this->link[] = $data;
		}
		return true;
	}
	function get(){
		$outTag	= new Tag("feed");
		$outTag->addParameterValue("xmlns","http://www.w3.org/2005/Atom");
		
		$tag = new Tag("id",$this->getId());
		$outTag->addValue($tag->get());
		$tag = new Tag("title",$this->getTitle());
		$outTag->addValue($tag->get());
		$tag = new Tag("subtitle",$this->getSubtitle());
		$outTag->addValue($tag->get());		
		
		$tag = new Tag("updated",$this->getUpdated());
		$outTag->addValue($tag->get());
		$tag = new Tag("generator",$this->getGenerator());
		$outTag->addValue($tag->get());		
		
		if(Variable::isClassType(AtomAuthor,$this->getAuthor())){
			$outTag->addValue($this->author->get());
		}		
		foreach($this->link as $data){
			if(Variable::isClassType(AtomLink,$data)){
				$outTag->addValue($data->get());
			}
		}
		foreach($this->entryList as $data){
			if(Variable::isClassType(AtomEntry10,$data)){
				$outTag->addValue($data->get());
			}
		}				
		return $outTag->get();
	}

	function setVersion($value){
		$this->version = $value;
	}
	function getVersion(){
		return $this->version;
	}
	function setId($value){
		$this->id = $value;
	}
	function getId(){
		return $this->id;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setSubtitle($value){
		$this->subtitle = $value;
	}
	function getSubtitle(){
		return $this->subtitle;
	}
	function setUpdated($value){
		$this->updated = $value;
	}
	function getUpdated(){
		return $this->updated;
	}
	function setGenerator($value){
		$this->generator = $value;
	}
	function getGenerator(){
		return $this->generator;
	}
	
	function addLink($href,$rel="",$type=""){
		$this->link[] = new AtomLink($href,$rel,$type);
	}
	function getLink(){
		return $this->link;
	}
	function getEntryList(){
		return $this->entryList;
	}
	function addEntry($title,$summary="",$content=""){
		$this->entryList[] = new AtomEntry10($title,$summary,$content);
	}
	function setEntryList($entryList){
		$this->entryList = $entryList;
	}	
	function setAuthor($name,$email="",$url=""){
		$this->author = new AtomAuthor($name,$email,$url);
	}
	function getAuthor(){
		return $this->author;
	}
}
?>