<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/TagParameter.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.1.9
 */
class Tag{
	var $name			= "";
	var $value			= "";
	var $plain			= "";
	var $parameterList	= array();
	var $attributeList	= array();

	function Tag($name="",$value=""){
		$this->setName($name);
		$this->setValue($value);
	}
	function set($plain,$name=""){
		if(empty($name)){
			if(preg_match("/<([\w\d:_-]+)[\s\t\n\r\>]/",preg_replace("/[\r\n]/","",$plain),$nameList)){
				$name = $nameList[1];
			}
		}
		if(!empty($name)){
			$this->_clear();
			$this->setName($name);
			$this->plain = $plain;
			
			if($this->plain != ""){
				return $this->_parse($this->plain,$this->getName());
			}
		}
		return false;
	}

    function get(){
		$tagParameter	= new TagParameter();
		$parmater   		= "";
		$attribute		= "";
		$tag        		= "";

		if(is_array($this->parameterList)){
			foreach($this->parameterList as $tagParameter){
				if(preg_match("/^TagParameter$/i",get_class($tagParameter))){
                    $parmater .= sprintf(" %s=\"%s\"",$tagParameter->getId(),$tagParameter->getValue());
				}
			}
        }
		if(is_array($this->attributeList)){
			foreach($this->attributeList as $tagAttribute){
				$attribute .= sprintf(" %s",$tagAttribute);
			}
		}
        if($this->getValue() != ""){
            $tag .= sprintf("<%s%s%s>",$this->getName(),$parmater,$attribute);
	        $tag .= sprintf("%s",$this->getValue());
	        $tag .= sprintf("</%s>",$this->getName());
        }else{
            $tag .= sprintf("<%s%s%s />",$this->getName(),$parmater,$attribute);        
        }
        return $tag;
    }
		
	function addParameterValue($id,$value){
		$tagParameter = new TagParameter();
		$tagParameter->setId($id);
		$tagParameter->setValue($value);
		
		return $this->addParameter($tagParameter);
	}
	function addParameter($tagParameter){
		if(preg_match("/^TagParameter$/i",get_class($tagParameter))){
			$this->parameterList[$tagParameter->getId()] = $tagParameter;
			return true;
		}
		return false;
	}

	function isParameter($parameterId){
		if(is_array($this->parameterList)){
			foreach($this->parameterList as $tagParameter){
				if(preg_match("/^TagParameter$/i",get_class($tagParameter))){
					if(strtolower($tagParameter->getId()) == strtolower($parameterId)){
						return true;
					}
				}
			}
		}
		return false;
	}
	
	function getParameter($parameterId,$defaultValue=""){
		$tagParameter = "";

		if(is_array($this->parameterList)){
			foreach($this->parameterList as $tagParameter){
				if(preg_match("/^TagParameter$/i",get_class($tagParameter))){
					if(strtolower($tagParameter->getId()) == strtolower($parameterId)){
						return $tagParameter->getValue();
					}
				}
			}
		}
		return $defaultValue;
	}
	function removeParameter($value){
		unset($this->parameterList[$value]);
	}
	function getParameterList(){
		return $this->parameterList;
	}
	function getParameterHash(){
		$hash = array();
		
		foreach($this->parameterList as $parameter){
			$hash[$parameter->getId()] = $parameter->getValue();
		}
		return $hash;
	}
	
	function addAttribute($value){
		$this->attributeList[$value] = $value;
	}
	function getAttribute($value){
		return $this->attributeList[$value];
	}
	function getAttributeList(){
		return $this->attributeList;
	}
	function removeAttribute($value){
		unset($this->attributeList[$value]);
	}	

	function getIn($tagName){
		$tagList = array();

		if(!empty($tagName) && $this->getValue() != ""){
			$plain = $this->getValue();

			while(true){
				$tag	 = new Tag();

				if(!$tag->set($plain,$tagName)){
					break;
				}
				$tagList[] = $tag;
				$plain = str_replace($tag->getPlain(),"",$plain);
			}
		}
		return $tagList;
	}

	function getValue(){
		return $this->value;
	}
	function setValue($value){
		$this->value = $value;
	}
	function addValue($value){
		$this->value = $this->value.$value;
	}
	function getName(){
		return $this->name;
	}
	function setName($value){
		$this->name = trim($value);
	}
	function getPlain(){
		return $this->plain;
	}
	
	function _clear(){
		$this->name		= "";
		$this->value		= "";
		$this->plain		= "";		
		$this->parameterList	= array();
		$this->attributeList	= array();
	}
	function _parseParameterAttribute($tag){
		$parameter = array();
		$attribute = array();

		if(!empty($tag)){
			if(preg_match_all("/[\s\t]+([\w\d\_\-\:]+)[\s\t]*=[\s\t]*([\"\'])([^\\2]*?)\\2/ms",$tag,$parameter)){
				foreach($parameter[0] as $id => $value){
					$tagParameter = new TagParameter();
					$tagParameter->setId($parameter[1][$id]);
					$tagParameter->setValue($parameter[3][$id]);

					$this->addParameter($tagParameter);
					$tag = str_replace($value,"",$tag);
				}
			}
			if(preg_match_all("/([\w\d\_\-]+)/",$tag,$attribute)){
				foreach($attribute[1] as $value){
					$this->addAttribute($value);
				}
			}
		}
	}
	function _parse($value,$name){
		if(trim($value) != ""){
			$yenn			= " __YENN__ ";
			$yenr			= " __YENR__ ";

			$value			= str_replace("\n",$yenn,str_replace("\r",$yenr,$value));
			$parse			= array();
			
			$startTagList	= array();
			$endTagList		= array();

			if(preg_match("/(<(".$name.")([\s\t][^>]*)?>)/i",$value,$parse)){
				if(substr($parse[1],-2) == "/>"){
					$this->_clear();
					$this->setName($parse[2]);
					$this->_parseParameterAttribute(str_replace($yenr,"",str_replace($yenn,"",$parse[3])));
					$this->plain = str_replace($yenr,"\r",str_replace($yenn,"\n",$parse[1]));
					return true;
				}else{
					$value			= substr($value,strpos($value,$parse[1]));
					$startTagList	= array();
					$endTagList		= array();

					if(preg_match_all("/(<\/".$name.">?)/i",$value,$endTagList)){
						if(preg_match_all("/(<".$name."[\s\t]([^>]*[^\/])?>)|(<".$name."?>)/i",$value,$startTagList)){
							$endTagLength	= array();
							$lineList		= array();
							$first			= 0;
							$balance			= 0;

							for($i=0,$offset=0;sizeof($startTagList[0])>$i;$i++,$offset++){
								$offset				= strpos($value,$startTagList[0][$i],$offset);
								$lineList[$offset]	= 1;
		
								if($i == 0){
									$first = $offset;
								}
							}
							for($i=0,$offset=$first;sizeof($endTagList[1])>$i;$i++,$offset++){
								$offset					= strpos($value,$endTagList[1][$i],$offset);
								$lineList[$offset]		= -1;
								$endTagLength[$offset]	= strlen($endTagList[1][$i]);
							}
							ksort($lineList);
							foreach($lineList as $line => $point){
								if(($balance += $point) == 0){
									$str = substr($value,$first,$line+$endTagLength[$line]-$first);

									if(preg_match("/((<[\s\t]*(".$name.")([\s\t]*[^>]*)>)(.*)(<[\s]*\/\\3[\s\t]*>))/i",$str,$parse)){
										$this->setName($parse[3]);
										$this->_parseParameterAttribute(str_replace($yenr,"",str_replace($yenn,"",$parse[4])));
										$this->setValue(str_replace($yenr,"\r",str_replace($yenn,"\n",$parse[5])));
										$this->plain = str_replace($yenr,"\r",str_replace($yenn,"\n",$parse[1]));
										
										return true;
									}
								}
							}
						}
					}
				}
			}
		}
		return false;
	}
}
?>