<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class ColumnModel{
	var $name;
	var $type;
	var $primary;
	var $size;
	var $default;
	var $require;
	var $variable;
	var $serial;
	var $method;
	
	function isTypeString(){
		if($this->type == "STRING" && $this->size > 0){
			return true;
		}
		return false;
	}
	function isTypeInteger(){
		if($this->type == "INTEGER" || $this->type == "SERIAL"){
			if(empty($this->size)){
				$this->size = 22;
			}
			return true;
		}
		return false;
	}
	function isTimestamp(){
		if($this->type == "TIMESTAMP"){
			return true;
		}
		return false;
	}
	function getDefault(){
		switch($this->type){
			case "INTEGER":
			case "SERIAL":
				return sprintf("%d",$this->default);
			case "BOOLEAN":
				if(Variable::getBoolean($this->default)){
					return "true";
				}
				break;
			case "STRING":
				if($this->default != ""){
					return sprintf("\"%s\"",$this->default);
				}
				break;
			case "TIMESTAMP":
				if($this->default != ""){
					if(preg_match("/sysdate/i",$this->default)){
						return "time()";
					}
					return DateUtil::format($value);
				}
		}
		return "null";
	}
}
?>