<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."Rhaco.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/RequireException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/DuplicateException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalStateException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class AuthFileManager{
	var $htmlParser;
	var $tagUtil;
	var $request;
	var $memberfile;
	var $fileUtil;

	function AuthFileManager(){
		$this->fileUtil		= new FileUtil();
		$this->htmlParser 	= new HtmlParser();
		$this->tagUtil 		= new TagUtil();
		$this->request		= new Request();
		$this->memberfile	= Rhaco::resource("member.xml");
		
		if(!$this->fileUtil->exist($this->memberfile)){
			$tag = new Tag("auth");
			$this->fileUtil->write($this->memberfile,$tag->get());
		}else{
			$tag = new Tag();
			if(!$tag->set($this->fileUtil->read($this->memberfile),"auth")){
				ExceptionTrigger::raise(new IllegalStateException($this->memberfile));
			}
		}
		if($this->request->isPost()){
			$tag = new Tag("user");

			if($this->request->isElement("delete")){
				$tag->addParameterValue("login",$this->request->getElement("login"));
				$this->tagUtil->delete($this->memberfile,$tag);
			}else{
				$login		= $this->request->getElement("login");
				$password	= $this->request->getElement("password");

				if(empty($login)){
					ExceptionTrigger::raise(new RequireException(Message::_("Login")));
				}
				if(empty($password)){
					ExceptionTrigger::raise(new RequireException(Message_("Password")));
				}
				if(!ExceptionTrigger::isException()){
					$tag->addParameterValue("login",$login);

					if($this->tagUtil->get($this->memberfile,$tag) != false){
						ExceptionTrigger::raise(new DuplicateException(Message::_("Login")));
					}else{
						$tag->addParameterValue("password",md5($password));	
						$this->tagUtil->insert($this->memberfile,$tag);

						$this->request->clearElement(array("login,password"));
					}
				}
			}
			$this->tagUtil->commit($memberfile);
		}
		$this->request->setElement("userList",$this->tagUtil->select($this->memberfile,new Tag("user")));
		$this->htmlParser->setRequest($this->request->getElements());
		$this->htmlParser->write(Rhaco::rhacoresource("templates/setup/memberManager.html"));
	}
}
?>