<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/data/RequestLoginCondition.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.0
 */
class RequestLogin extends Request{
	function RequestLogin($request=array()){
		session_start();
		parent::Request($request);
	}
	function login($requestLoginCondition=null){
		if(!RequestLogin::isLogin()){
			$this->logout();		
			if(!Variable::isClassType(RequestLoginCondition,$requestLoginCondition)){
				$requestLoginCondition = new RequestLoginCondition();
			}
			if(!$requestLoginCondition->condition($this)){
				$requestLoginCondition->invalid($this);
				return false;
			}
			setcookie(RequestLogin::getSessionLoginIdName(),session_id(),time() + Rhaco::define("COOKIE_EXPIRE_TIME",0));
			$_SESSION[RequestLogin::getSessionLoginIdName()] = session_id();
			
			$requestLoginCondition->after();			
		}
		return true;
	}
	function logout(){
		setcookie(RequestLogin::getSessionLoginIdName(),"",time() - 3600);
		unset($_SESSION[RequestLogin::getSessionLoginIdName()]);
		unset($_SESSION[RequestLogin::getSessionLoginName()]);		
	}
	function getSessionLoginIdName(){
		return Rhaco::define("REQUEST_SESSION_LOGIN_ID","LOGIN_ID");
	}
	function getSessionLoginName(){
		return Rhaco::define("REQUEST_SESSION_LOGIN","LOGIN");
	}	
	function isLogin(){
		return isset($_SESSION[RequestLogin::getSessionLoginIdName()]);
	}
	function getLoginCookieId(){
		return $_COOKIE[RequestLogin::getSessionLoginIdName()];
	}
	function getLoginSessionId(){
		return $_SESSION[RequestLogin::getSessionLoginIdName()];		
	}
	function getLoginSession(){
		return $_SESSION[RequestLogin::getSessionLoginName()];		
	}
	function setLoginSession($value){
		$_SESSION[RequestLogin::getSessionLoginName()] = $value;
	}
}
?>