<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.5
 */
class Request{
	var $request	= array();
	var $session	= array();	
	var $files	= array();
	var $post	= false;
	
	var $sessionExpire		= 2592000;	
	var $cacheLimiter		= "nocache";	/** @note (none/nocache/private/private_no_expire/public) */

	function Request($request=array()){
		$this->reset();

		session_cache_limiter(Rhaco::define("SESSION_CACHE_LIMITER",$this->cacheLimiter));
		session_cache_expire(Rhaco::define("SESSION_EXPIRE_TIME",$this->sessionExpire));

		if(is_array($_FILES)){
			foreach($_FILES as $key => $files){
				$this->files[$key] = $this->parseFileElement($files);
			}
		}
		if(is_array($_SESSION)){
			foreach($_SESSION as $key => $session){
				$this->session[$key] = Variable::getMagicQuotesOffValue($session);
			}
		}
		if(is_array($_COOKIE)){
			foreach($_COOKIE as $key => $cookie){
				$this->session[$key] = Variable::getMagicQuotesOffValue($cookie);
			}
		}
		if(is_array($_POST) && sizeof($_POST) > 0){
			$this->post = true;
			
			foreach($_POST as $key => $post){
				$this->request[$key] = Variable::getMagicQuotesOffValue($post);
			}
		}
		if(is_array($_GET)){
			foreach($_GET as $key => $get){
				$this->request[$key] = Variable::getMagicQuotesOffValue($get);
			}
		}
		if(is_array($request)){
			foreach($request as $key => $value){
				$this->request[$key] = Variable::getMagicQuotesOffValue($value);
			}
		}
		$this->request["args"] = preg_replace("/(.*?)\?.+/","\\1",substr($_SERVER["REQUEST_URI"],strlen($_SERVER["SCRIPT_NAME"])));
		$this->validate();
	}

	function reset(){
	}
	function validate(){
	}
	function isPost(){
		return $this->post;
	}
	function isElement($elementName){
		return array_key_exists($elementName,$this->request);
	}
	function setElement($elementName,$element){
		$this->request[$elementName] = $element;
	}
	function getElement($elementName,$defaultData=""){
		if($this->request[$elementName] == null){
			return $defaultData;
		}
		return $this->request[$elementName];
	}
	function clearElement($elementName){
		if(is_array($elementName)){
			foreach($elementName as $name){
				unset($this->request[$name]);
			}
		}else{
			unset($this->request[$elementName]);
		}
	}
	function mergeElements($hash){
		if(is_array($hash)){
			$this->request = array_merge($this->request,$hash);
		}
	}
	function getElements(){
		return $this->request;
	}
	function clearElements(){
		$this->request = array();
	}

	function isSession($elementName){
		return array_key_exists($elementName,$this->session);
	}
	function setSession($elementName,$element){
		$this->session[$elementName] = $element;
	}
	function getSession($elementName,$defaultData=""){
		if($this->session[$elementName] == null){
			return $defaultData;
		}
		return $this->session[$elementName];
	}
	function clearSession($elementName){
		unset($this->session[$elementName]);
	}
	function getSessions(){
		return $this->session;
	}
	function clearSessions(){
		$this->session = array();
	}
	
	function getFiles(){
		return $this->files;
	}
	function getFile($elementName){
		if(!isset($this->files[$elementName])){
			$requestFiles			= array();
			$requestFiles['name']		= $elementName;
			$requestFiles['error']	= UPLOAD_ERR_NO_FILE;

			return $this->parseFileElement($requestFiles);
		}
		return $this->files[$elementName];
	}
	function isFile($elementName){
		return Variable::isClassType(File,$this->files[$elementName]);
	}

	function parseFileElement($requestFiles){
		$fileElement				= new File($requestFiles['name']);
		$fileElement->tmp		= $requestFiles['tmp_name'];
		$fileElement->size		= $requestFiles['size'];
		$fileElement->error		= $requestFiles['error'];

		return $fileElement;
	}
	function toObject(&$object){
		return Variable::hashConvObject($this->getElements(),$object);
	}

	function parseObject($object){
		foreach(Variable::objectConvHash($object) as $key => $value){
			$this->setElement($key,$value);
		}
	}
	function getUrlMapList($hash=array()){
		if(empty($this->request["args"])){
			return array();
		}
		$list		= explode("/",$this->request["args"]);
		$hashList	= array();
		$resultList	= array();

		foreach($hash as $arg){
			$hashList[] = $arg;
		}		
		foreach($list as $key => $arg){
			if(isset($hashList[$key])){
				$key = $hashList[$key];
			}
			$resultList[$key] = $arg;
		}
		return $resultList;
	}
	function getUrlMap($key,$hash=array()){
		$list = $this->getUrlMapList($hash);
		return $list[$key];
	}
}
?>