<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.3
 */
class Http{
	function request($url,$method="GET",$hearder=array(),$timeout=5){
		$query		= "";
		$header = "";
		$body	= "";

		if(!empty($url)){
			$urlList		= parse_url($url);
			$port		= $urlList["port"];
			$host		= $urlList["host"];

			if(empty($urlList["port"])){
				$port = 80;

				if($urlList["scheme"] == "ssl" || $urlList["scheme"] == "https"){
					$port = 443;
				}
			}
			$fp	= @fsockopen($host,$port,$errorno,$errormsg,$timeout);
			
			if(!$fp){
				Logger::warning(Message::_("network error {1} ({2}) - {3}",$errstr,$errno,$url));
				return array();
			}
			if(isset($urlList["query"])){
				$urlList["query"] = sprintf("?%s",$urlList["query"]);
			}
			if(empty($urlList["path"])){
				$urlList["path"] = "/";
			}
			$query .= sprintf("%s %s%s HTTP/1.1\r\n",$method,$urlList["path"],$urlList["query"]);
			$query .= sprintf("Host: %s\r\n",$host);
			$query .= sprintf("User-Agent: %s\r\n",$_SERVER["HTTP_USER_AGENT"]);

			if(isset($urlList['user']) && isset($urlList['pass'])) {
			    $query .= sprintf("Authorization: Basic %s\r\n",base64_encode(sprintf("%s:%s",$urlList["user"],$urlList["pass"])));
			}
			if(!empty($hearder) && is_array($hearder)){
				foreach($hearder as $key => $value){
					$query .= sprintf("%s: %s\r\n",$key,$value);
				}
			}
			$query .= sprintf("Connection: Close\r\n\r\n");

			fwrite($fp,$query);
			socket_set_timeout($fp,$timeout);

			while(!feof($fp) && !preg_match("/\r\n\r\n$/",$header)){
				$header .= fgets($fp,4096);
			}
			if(preg_match("/Transfer\-Encoding:[\s]+chunked/i",$header)){
				while(!feof($fp)){
					$bytes = fgets($fp,4096);

					if(preg_match("/^([0-9a-fA-F]+)[\r\n]*$/",$bytes,$match)){
						$size = hexdec($match[1]);

						if($size == 0){
							break;
						}
						$body .= fread($fp,$size);
					}else{
						$body .= $bytes;
					}
				}
			}else if(preg_match("/Content\-Length:[\s]+([0-9]+)\r\n/i",$header,$match)){
					while(!feof($fp)){
						$body .= fread($fp,4096);
					}
			}else{
				while(!feof($fp)){
					$body .= fread($fp,4096);
				}
			}
		}
		fclose($fp);

		return array($header,$body);		
	}
	function body($url,$method="GET",$hearder=array(),$timeout=2){
		list($head,$body) = Http::request($url,$method,$hearder,$timeout);

		$redirectUrl			= array();
		$httpCode			= array();

		if(!empty($head)){
			if(preg_match("/HTTP\/.+[\040](\d\d\d)/i",$head,$httpCode)){
				if($httpCode[1] != "200"){
					if($httpCode[1] == "302"){
						if(preg_match("/Location:[\040](.*)/i",$head,$redirectUrl)){
							return Http::body($redirectUrl[1],$method);
						}
					}
					return false;
				}
			}
		}		
		return $body;		
	}
	function head($url,$hearder=array(),$timeout=5){
		list($head,$body) = Http::request($url,"HEAD",$hearder,$timeout);
		unset($body);
		return $head;
	}
}
?>