<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");

/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.1
 */
class Validate{
	function isInt($variable,$minSize,$maxSize){
		return $this->isInteger($variable,$minSize,$maxSize);
	}
	function isIntegerLength($variable,$maxLength){
		if(!preg_match("/[^0-9]+/",$variable)){
			if(strlen($variable) <= $maxLength){
				return true;
			}
		}
		return false;
	}
	function isInteger($variable,$minSize,$maxSize){
		if(!preg_match("/[^0-9]+/",$variable)){
			if($minSize <= $variable && $variable <= $maxSize){
				return true;
			}
		}
		return false;
	}

	function isString($variable,$minSize,$maxSize){
		if($minSize <= strlen($variable) && strlen($variable) <= $maxSize){
			return true;
		}
		return false;
	}

	function isAlphabet($variable){
		if(preg_match("/^[a-z]+$/i",$variable)){
			return true;
		}
		return false;
	}

	function isUrl($variable){
		if($this->isString($variable,1,255)){
			if(preg_match("/^[a-z][\w]*$/i",$variable)){
				return true;
			}
		}
		return false;
	}

	function isFilename($variable){
		if($this->isString($variable,1,64)){
			if(preg_match("/^[\w][\w\.]*$/i",$variable)){
				return true;
			}
		}
		return false;
	}

	function isTimestamp($timestamp){
		if(is_int($timestamp) || empty($requestValidate)){
			return true;
		}
		$timestampList	= array();
		$timestamp		= preg_replace("/[^0-9]/","",$timestamp);
		if(preg_match("/^([1-2][0-9][0-9][0-9])([0-1][0-9])([0-3][0-9])([0-2][0-9])([0-5][0-9])([0-5][0-9])$/",$timestamp,$timestampList)){
			return $this->isDate($timestampList[1],$timestampList[2],$timestampList[3]);
		}
		return false;
	}

	function isDate($year,$month,$day){
		if($this->isInteger($year,1900,2050)){
			if($this->isInteger($month,1,12)){
				if($this->isInteger($day,1,31)){
					return checkdate($month,$day,$year);
				}
			}
		}
		return false;
	}

	function isTel($tel1,$tel2,$tel3){
		if($this->isInteger($tel1,0,99999) &&
			$this->isInteger($tel2,0,99999) &&
			$this->isInteger($tel3,0,99999)
		){
			if($this->isString($tel1.$tel2.$tel3,9,11)){
				return true;
			}
		}
		return false;
	}

	function isZip($zip1,$zip2){
		if($this->isInteger($zip1,0,999) &&
			$this->isInteger($zip2,0,9999)
		){
			if($this->isString($zip1.$zip2,7,7)){
				return true;
			}
		}
		return false;
	}

	function isEmail($email){
		 if(preg_match("/^[a-z0-9_\.][^@]*@[^.]+\..+/",$email) && strlen($email) <= 255){
			return true;
		 }
		 return false;
	}

	function isCreditcard($no1,$no2,$no3,$no4){
		if($this->isInteger($no1,0,9999) &&
			$this->isInteger($no2,0,9999) &&
			$this->isInteger($no3,0,9999) &&
			$this->isInteger($no4,0,9999)
		){
			if($this->isString($no1.$no2.$no3.$no4,16,16)){
				return true;
			}
		}
		return false;
	}

	function isKatakana($katakana){
		if(!empty($katakana)){
			$format		= "アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヲンガギグゲゴザジズゼゾダヂヅデドバビブベボパピプペポヴァィゥェォャュョッ　ー－（）() ";
			$katakana	= StringUtil::convertKana($katakana);

			for($i=0;$i<=StringUtil::strlen($format);$i++){
				$kana[StringUtil::substr($format,$i,1)] = 1;
			}
			for($i=0;$i<=StringUtil::strlen($katakana);$i++){
				$char = StringUtil::substr($katakana,$i,1);

				if(!preg_match("/[\040]/",$char) && $kana[$char] != 1){
					return false;
				}
			}
		}
		return true;
	}

	function isEmpty($str){
		if(empty($str)){
			return true;
		}
		return false;
	}
}