<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.6
 */
class StringUtil{
	function getEncodeTypeUTF8(){
		return "UTF-8";
	}
	function getEncodeTypeSJIS(){
		return "SJIS";
	}
	function getEncodeTypeEUC(){
		return "EUC-JP";
	}
	function getEncodeTypeJIS(){
		return "JIS";
	}
	function encoding($value,$encodeType,$lang="Japanese"){
		if(!empty($encodeType)){
			if(extension_loaded("mbstring")){
				if(!empty($encodeType) && !empty($value)){
					if(!empty($lang)){
						 mb_language($lang);
					}
					if("neutral" == mb_language()){
						mb_language("Japanese");
					}
					return @mb_convert_encoding($value,$encodeType,mb_detect_encoding($value,"auto"));
				}
			}
		}
		return $value;
	}

	function convertKana($value){
		if(extension_loaded("mbstring")){
			return mb_convert_kana($value,"KV");
		}
		return $value;
	}
	function convertZenhan($value,$encodeType="UTF-8"){
		if(extension_loaded("mbstring")){
			if(empty($encodeType)){
				$encodeType = mb_detect_encoding($value,"auto");
			}
			$value = mb_convert_kana($value,"askV",$encodeType);
		}
		return $value;
	}
	function convertHanzen($value,$encodeType=null){
		if(extension_loaded("mbstring")){
			if(empty($encodeType)){
				$encodeType = mb_detect_encoding($value,"auto");
			}
			$value = mb_convert_kana($value,"ASKV",$encodeType);
		}
		return $value;		
	}	

	function getDetectEncoding($str="ラコホラス"){
		if(extension_loaded("mbstring")){
			return mb_detect_encoding($str);
		}
		return "UTF-8";
	}

	function replace($src,$preg,$replace="",$option=""){
		if(!empty($preg)){
			if(substr($preg,0,1) == "/"){
				if(extension_loaded("mbstring")){
					if(strpos($option,"i") === false){
						return mb_ereg_replace(substr($preg,1,-1),$replace,$src);						
					}
					return mb_eregi_replace(substr($preg,1,-1),$replace,$src);
				}
				return preg_replace(sprintf("%s%s",$preg,$option),$replace="",$src);
			}
			return str_replace($preg,$replace,$src);
		}
		return $src;
	}

	function strlen($str){
		if(extension_loaded("mbstring")){
			return mb_strlen($str);
		}
		return strlen($str);
	}

	function substring($str,$start,$length=""){
		if(extension_loaded("mbstring")){
			mb_substr($str,$start,$length);
		}
		return substr($str,$start,$length);
	}

	function getIncludeSeparate(){
		if(!empty($_SERVER["WINDIR"]) || !empty($_SERVER["PROGRAMFILES"])){		
			return ";";
		}
		return ":";	
	}
	function sprintf(){
		$argList		= func_get_args();
		$argsize		= sizeof($argList);

		if($argsize > 0){
			$paramList		= array();
			$paramsize		= substr_count($argList[0],"%");
			$propertiesize	= $argsize - 1;

			for($i=1;$i<$argsize;$i++){
				$paramList[] = $argList[$i];
			}			
			if($paramsize > $propertiesize){
				for($i=0;$i<$paramsize-$propertiesize;$i++){
					$paramList[] = "";
				}
			}
			return vsprintf($argList[0],$paramList);
		}
		return "";
	}
}	
?>