<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class DateUtil{
	function add($time,$seconds=0,$minutes=0,$hours=0,$day=0,$month=0,$year=0){
		$dateList	= getdate(intval($time));

		return mktime($dateList["hours"] + $hours,
						$dateList["minutes"] + $minutes,
						$dateList["seconds"] + $seconds,
						$dateList["mon"] + $month,
						$dateList["mday"] + $day,
						$dateList["year"] + $year
					);
	}
	function addDay($time,$add){
		return DateUtil::add($time,0,0,0,$add);
	}
	function addHour($time,$add){
		return DateUtil::add($time,0,0,$add);
	}
	function parseString($str){
		if(!empty($str)){
			if(is_string($str)){
				if(preg_match("/(.+)([\+\-])(\d\d).*(\d\d)$/",$str,$tmp)){
					$addtime = (intval($tmp[3]) * 3600) + (intval($tmp[4]) * 60);
					if($tmp[2] == "-"){
						$addtime = $addtime * -1;
					}
					$str = $tmp[1];
				}
				$time = strtotime($str) + $addtime;				
			}else{
				$time = intval($str);
			}
			if($time > 0){
				return $time;
			}
		}
		return;
	}
	function formatFull($time){
		return date("Y/m/d H:i:s (D)",intval($time));
	}
	function format($time){
		return date("Y/m/d H:i:s",intval($time));
	}
	function formatAtom($time,$addminutes=0){
		return date("Y-m-d\TH:i:s\Z",intval($time)+intval($addminutes));
	}
}
?>