<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/PermissionException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.2
 */
class File{
	var $directory;
	var $fullname;
	var $name;
	var $originalName;
	var $extension;
	var $size;
	var $update;

	var $tmp;
	var $error;

	function File($fullname){
		$this->fullname = $fullname;
		$this->parseFullname();
	}
	function parseFullname(){
		$info = @pathinfo(str_replace("\\","/",$this->fullname));
		$this->directory	= $info["dirname"];
		$this->name			= $info["basename"];
		$this->extension	= ".".$info["extension"];
		$this->originalname	= @basename($this->name,$this->extension);

		if($this->isFile()){
			$this->update	= @filemtime($this->fullname);
			$this->size		= sprintf("%u",@filesize($this->fullname));
		}
	}
	function generate($filename){
		if(@copy($this->tmp,$filename)){
			if(@unlink($this->tmp)){
				$this->fullname = $filename;
				$this->parseFullname();

				return true;
			}
		}
		ExceptionTrigger::raise(new PermissionException($filename));		
		return false;
	}

	function isFile(){
		return is_file($this->fullname);
	}

	function move($filePath){
		if($this->copy($filePath)){
			return $this->delete();
		}
		return false;
	}

	function delete(){
		return unlink($this->fullname);
	}

	function copy($filePath){
		if(!empty($filePath)){
			if(copy($this->fullname,$filePath)){
				return true;
			}
		}
		return false;
	}
	

	function getDirectory(){
		return $this->directory;
	}
	function getFullname(){
		return $this->fullname;
	}
	function getName(){
		return $this->name;
	}
	function getOriginalName(){
		return $this->originalName;
	}
	function getExtension(){
		return $this->extension;
	}
	function getSize(){
		return $this->size;
	}
	function getUpdate($dateformat=""){
		if(!empty($dateformat)){
			return date($dateformat,$this->update);
		}
		return $this->update;
	}
	function getTmp(){
		return $this->tmp;
	}
	function isError(){
		return (intval($this->error) > 0);
	}
}
?>