<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Http.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/PermissionException.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class Stream{
	function read($url){
		$src = "";

		if(preg_match("/[\w]+:\/\/[\w]+/",$url)){
			if(preg_match("/php:\/\/(.+)/i",$url,$type)){
				$type = strtolower($type);
				
				if($type == "stdin"){
					$src = Stream::stdin();
				}else if($type == "input"){
					$src = Stream::input();					
				}
			}else{
				$src		= Http::get($url);
			}
		}else{
			$fileUtil	= new FileUtil();
			$src			= $fileUtil->read($url);
		}
		return StringUtil::encoding($src,StringUtil::getDetectEncoding());
	}
	function write($url,$value){
		if(preg_match("/[\w]+:\/\/[\w]+/",$url)){
			if(preg_macth("/php:\/\/(.+)/i",$url,$type)){
				$type = strtolower($type);
				
				if($type == "stdout"){
					Stream::stdout($value);
				}else if($type == "stderr"){
					Stream::stderr($value);					
				}else if($type == "output"){
					Stream::output($value);					
				}
			}
		}else{
			$fileUtil	= new FileUtil();
			$fileUtil->write($url,$value);
		}
	}
	function stdin(){
		$buffer	= "";
		$fp		= fopen("php://stdin","r");
		
		if(!$fp){
			ExceptionTrigger::raise(new PermissionException("php://stdin"));
			return false;
		}
		while(!feof($fp)){
			$buffer .= fgets($fp,4096);
		}
		fclose($fp);

		return $buffer;
	}
	function input(){
		$buffer	= "";
		$fp	= fopen("php://input","r");

		if(!$fp){
			ExceptionTrigger::raise(new PermissionException("php://stdin"));
			return false;
		}
		while(!feof($fp)){
			$buffer .= fgets($fp,4096);
		}
		fclose($fp);

		return $buffer;
	}
	function stdout($value){
		$fp		= fopen("php://stdout","w");

		if(!$fp){
			ExceptionTrigger::raise(new PermissionException("php://stdin"));
			return false;
		}
		fwrite($fp,$value);
		fclose($fp);
		return true;
	}	
	function stderr($value){
		$fp		= fopen("php://stderr","w");
		if(!$fp){
			ExceptionTrigger::raise(new PermissionException("php://stdin"));
			return false;
		}
		fwrite($fp,$value);
		fclose($fp);
		return true;
	}
	function output($value){
		$fp		= fopen("php://output","w");
		if(!$fp){
			ExceptionTrigger::raise(new PermissionException("php://stdin"));
			return false;
		}
		fwrite($fp,$value);
		fclose($fp);
		return true;
	}
}
?>