<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/PermissionException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.1.2
 */
class FileUtil{
	var $resource	= array();
	var $source		= array();
	var $lockfile	= array();
	var $regClose	= true;
	var $transaction = false;
	var $lock		= true;
	
	function read($filename,$enc=""){
		if($this->isFile($filename) && $this->open($filename)){
			$buffer = $this->fgets($filename,$enc);
			if(!($buffer === false)){
				if($this->close($filename)){
					return $buffer;
				}
			}
		}
		return false;
	}
	function write($filename,$src="",$enc=""){
		if($this->open($filename)){
			if($this->fwrite($filename,$src,$enc)){
				if($this->close($filename)){
					return true;
				}
			}
		}
		return false;
	}
	function append($filename,$src="",$enc=""){
		if($this->open($filename)){
			if($this->fputs($filename,$src,$enc)){
				if($this->close($filename)){
					return true;
				}
			}
		}
		return false;
	}
	
	function getFilePath($base,$path=""){
		$null = null;
		$base = preg_replace("/[\/\/]/","/",str_replace("\\","/",$base));
		$path = preg_replace("/[\/\/]/","/",str_replace("\\","/",$path));

		if(preg_match("/[\/]$/",$base,$null)){
			$base = substr($base,0,-1);
		}
		if(preg_match("/^[\/]/",$path,$null)){
			$path = substr($path,1);
		}
		return sprintf("%s/%s",$base,$path);
	}
	function exist($filename){
		$filename = trim($filename);

		if(is_readable($filename)){
			if(is_file($filename)){
				return true;
			}else if(is_dir($filename)){
				return true;
			}else if(is_link($filename)){
				return true;
			}
		}
		return false;
	}
	function isFile($filename){
		if(is_readable($filename)){
			if(is_file($filename)){
				return true;
			}
		}
		return false;
	}
	function isDir($filename){
		if(is_readable($filename) && is_executable($filename)){
			if(is_dir($filename)){
				return true;
			}
		}
		return false;
	}
	
	function find($pattern,$directory,$recursive=false){
		$match		= array();
		$directory	= trim($directory);

		$fileList = FileUtil::getFileList($directory,$recursive);

		if(!empty($fileList)){
			if(!preg_match("/\/.+\//",$pattern)){
				$pattern = "/".$pattern."/";
			}			
			foreach($fileList as $dataFile){
				if(preg_match($pattern,$dataFile->name)){
					$match[$dataFile->name] = $dataFile;
				}
			}
		}
		return $match;
	}

	function getFileList($directory,$recursive=false){
		$dataFileList	= array();
		$directory		= trim($directory);

		if(substr($directory,-1) == "/"){
			$directory = substr($directory,0,-1);
		}
		if($handle = @opendir($directory)){
			while($pointer = readdir($handle)){
				if($pointer != "." && $pointer != ".."){
					$source = sprintf("%s/%s",$directory,$pointer);

					if(is_file($source)){
						$dataFile = new File(sprintf("%s/%s",$directory,$pointer));
						$dataFileList[$dataFile->fullname] = $dataFile;
					}else{
						if($recursive){
							$dataFileList = array_merge($dataFileList,FileUtil::getFileList($source,$recursive));
						}
					}
				}
			}
			closedir($handle);
		}
		return $dataFileList;
	}		
	function getDirNameList($directory){
		$list = array();
		$directory = trim($directory);

		if(is_dir($directory)){
			if($handle = @opendir($directory)){
				while($pointer = readdir($handle)){
					if(	$pointer != "." && $pointer != ".."){
						if(is_dir(sprintf("%s/%s",$directory,$pointer))){
							$list[$pointer] = $pointer ;
						}
					}
				}
				closedir($handle) ;
			}
			return $list ;
		}
		return false;
	}

	function cp($source,$dest,$parmission=755){
		$source			= $this->parserLastString($source);
		$dest			= $this->parserLastString($dest);
		$filenameList	= array();

		if(!is_dir($dest)){
			$this->mkdir($dest,$parmission);
		}
		if(is_dir($source)){
			if($handle = opendir($source)){
				while($pointer = readdir($handle)){
					if(	$pointer != "." && $pointer != ".."){
						$fullname	= sprintf("%s/%s",$source,$pointer);
						$targetname	= sprintf("%s/%s",$dest,$pointer);

						if(is_dir($fullname)){
							$this->mv($fullname,$targetname);
						}else if(is_file($fullname)){
							if(!@copy($fullname,$targetname)){
								return false;
							}
						}
					}
				}
				closedir($handle);
			}
		}else{
			if(preg_match("/.+\/(.+)$/",$source,$filenameList)){
				$filename = $filenameList[1];
			}else{
				$filename = $source;
			}
			if(!@copy($source,$dest."/".$filename)){
				return false;
			}
		}
		return true;
	}

	function rm($source){
		$source	= $this->parserLastString($source);

		if(is_writable($source)){
			if(is_dir($source)){
				if($handle = @opendir($source)){
					while($pointer = readdir($handle)){
						if($pointer != "." && $pointer != ".."){
							if(!$this->rm(sprintf("%s/%s",$source,$pointer))){
								return false;
							}
						}
					}
					closedir($handle);
				}
				return rmdir($source);
			}else if(is_file($source)){
				return unlink($source);
			}
		}
		return false;
	}

	function mv($source,$dest){
		$source	= $this->parserLastString($source);
		$dest	= $this->parserLastString($dest);

		return rename($source,$dest);
	}
	function mkdir($source,$permission=755){
		$source = $this->parserLastString($source);
		$source = str_replace("\\","/",$source);
		
		if($this->exist($source)){
			return true;
		}
		while(!empty($source) && !$this->exist($source)){
			$rootIndex	= strrpos($source,"/");
			$rootPath	= substr($source,0,$rootIndex);

			if($rootIndex === false || $rootIndex <= 1){
				break;
			}else{
				if($this->exist($rootPath)){
					if(is_writable($rootPath)){
						if(mkdir($source)){
							return FileUtil::chmod($source,$permission);
						}
					}else{
						ExceptionTrigger::raise(new PermissionException($source));
						break;
					}
				}
				$rootPathList = parse_url(substr($source,0,$rootIndex));
				if(empty($rootPathList["path"])){
					break;
				}
				if(!$this->mkdir(substr($source,0,$rootIndex),$permission)){
					break;
				}
			}
		}
		return false;
	}
	function chmod($source,$permission=0755){
		if($this->exist($source) && substr(PHP_OS,0,3) != 'WIN'){
			return chmod($source,eval(sprintf("return %04d;",$permission)));
		}
		return true;
	}
	function chown($source,$user,$group=""){
		if($this->exist($source) 	&& substr(PHP_OS,0,3) != 'WIN'){
			if(chmod($source,$user)){
				if($group != ""){
					return @chgrp($source,$group);
				}
				return true;
			}
		}
		return false;
	}
	function getSize($filename,$format = "kb"){
		$size		= 0;
		$filename	= trim($filename);

		if(is_file($filename)){
			$format	= strtolower($format);

			if($format == "b"){
				$size = filesize($filename);
			}else if($format == "mb"){
				$size = ceil((filesize($filename) / 1024) / 1024);
			}else if($format == "gb"){
				$size = ceil(((filesize($filename) / 1024) / 1024) / 1024);
			}else if($format == "tb"){
				$size = ceil((((filesize($filename) / 1024) / 1024) / 1024) / 1024);
			}else{
				$size = ceil(filesize($filename) / 1024);
			}
		}
		return $size;
	}
	function getFreeSpace($directory,$format="kb"){
		$size		= 0;
		$directory	= trim($directory);

		if(is_dir($directory)){
			if($format == "b"){
				$size = disk_free_space($directory);
			}else if($format == "mb"){
				$size = ceil((disk_free_space($directory) / 1024) / 1024);
			}else if($format == "gb"){
				$size = ceil(((disk_free_space($directory) / 1024) / 1024) / 1024);
			}else if($format == "tb"){
				$size = ceil((((disk_free_space($directory) / 1024) / 1024) / 1024) / 1024);
			}else{
				$size = ceil(disk_free_space($directory) / 1024);
			}
		}
		return $size;
	}

	function getUpdateTime($filename){		
		if(is_file($filename)){
			return filemtime($filename);
		}
		return false;
	}
	
	function parserLastString($filename){
		$filename = trim($filename);

		if(substr($filename,-1) == "/" || substr($filename,-1) == "\\"){
			$filename = substr($filename,0,-1);
		}
		return $filename;
	}
	function open($filename){
		if(!isset($this->resource[$filename]) || !is_resource($this->resource[$filename])){
			if($this->mkdir(dirname($filename))){
				$this->resource[$filename] = @fopen($filename,"ab+");
	
				if(!is_resource($this->resource[$filename])){
					$this->resource[$filename] = @fopen($filename,"r");
				}
				if(!is_resource($this->resource[$filename])){
					unset($this->resource[$filename]);
				}else{
					if($this->transaction){
						$this->_setSource($filename);
					}
					if($this->_lock($filename)){
						if(!$this->regClose){
							register_shutdown_function(array($this,'close'));
							$this->regClose = true;
						}
						return true;
					}
				}
			}
		}
		ExceptionTrigger::raise(new PermissionException($filename));
		return false;
	}
	function close($filename=""){
		$list = array();

		if(empty($filename)){
			$list = $this->resource;
		}else{
			$list[$filename] = $this->resource[$filename];
		}
		foreach($list as $name => $fp){
			if(is_resource($this->resource[$name])){
				if($this->_lock($filename,LOCK_UN)){
					fclose($this->resource[$name]);
				}
			}
			unset($this->resource[$name]);
			unset($this->source[$name]);			
		}
		return true;
	}
	function fgets($filename,$enc=""){
		$buffer = "";

		if(!is_resource($this->resource[$filename])){
			if(!$this->open($filename)){
				return false;
			}
		}
		if($this->transaction){
			$buffer = $this->source[$filename];
		}else{
			$this->_seekhome($filename);
			while(!feof($this->resource[$filename])){
				$buffer .= fgets($this->resource[$filename],4096);
			}
		}
		return StringUtil::encoding($buffer,$enc);
	}
	function fputs($filename,$src,$enc=""){
		if(!is_resource($this->resource[$filename])){
			if(!$this->open($filename)){
				return false;
			}
		}
		if($this->_seekend($filename)){
			$src = StringUtil::encoding($src,$enc);
			
			if($this->transaction){
				$this->source[$filename] = $this->source[$filename].$src;
				return true;
			}else{
				if(!(false === fwrite($this->resource[$filename],$src))){
					return true;
				}
				ExceptionTrigger::raise(new PermissionException($filename));
			}
		}
		return false;
	}
	function fwrite($filename,$src,$enc=""){
		if(!is_resource($this->resource[$filename])){
			if(!$this->open($filename)){
				return false;
			}
		}
		if($this->_seekhome($filename)){
			$src = StringUtil::encoding($src,$enc);

			if($this->transaction){
				$this->source[$filename] = $src;

				return true;
			}else{
				if(ftruncate($this->resource[$filename],0)){
					if(!(false === fwrite($this->resource[$filename],$src))){
						return true;
					}
				}
				ExceptionTrigger::raise(new PermissionException($filename));
			}
		}
		return false;
	}
	function setTransaction($bool){
		$this->transaction = Variable::getBoolean($bool);
	}
	function setLock($bool,$filename=""){
		$bool = Variable::getBoolean($bool);

		if(empty($filename)){
			$this->lock = $bool;
		}else{
			$this->lockfile[$filename] = $bool;
		}
	}
	function commit($filename){
		if($this->transaction){
			if($this->_seekhome($filename) && ftruncate($this->resource[$filename],0)){
				if(false === fwrite($this->resource[$filename],$this->source[$filename])){
					return false;
				}
			}
		}
		return true;
	}
	function rollback($filename){
		if($this->transaction){
			$this->_setSource($filename);
		}
	}
	function _setSource($filename){
		$buffer = "";
		$this->_seekhome($filename);
		while(!feof($this->resource[$filename])){
			$buffer .= fgets($this->resource[$filename],4096);
		}
		$this->source[$filename] = $buffer;
	}
	function _lock($filename,$mode=LOCK_SH){
		if($this->lock && !preg_match("/\:\/\//",$filename) &&
			(!isset($this->lockfile[$filename]) || $this->lockfile[$filename] == true)
		){
			$timecounter = 0;
	
			if($mode == LOCK_SH && substr(PHP_OS,0,3) == 'WIN'){
				$mode = LOCK_EX;
			}
			if(!flock($this->resource[$filename],$mode)){
				ExceptionTrigger::raise(new PermissionException($filename));
				return false;
			}
		}
		return true;
	}
	function _seekend($filename){
		if(!preg_match("/\:\/\//",$filename)){
			if(fseek($this->resource[$filename],0,SEEK_END) >= 0){
				return true;
			}
		}
		return false;
	}
	function _seekhome($filename){
		if(!preg_match("/\:\/\//",$filename)){
			if(fseek($this->resource[$filename],0,SEEK_SET) >= 0){
				return true;
			}
		}
		return false;
	}
}
?>