<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class ExceptionBase{
	var $message			= "";
	var $target			= "";
	var $properties		= array();

	function ExceptionBase($properties=array()){
		if(!is_array($properties)){
			$properties = array($properties);
		}
		$this->properties	= $properties;
	}
	function getMessage(){
		$propertiesize	= sizeof($this->properties);
		$message			= $this->message;

		if(preg_match_all("/(\{([\d]+)\})/",$message,$matches)){
			$paramsize = sizeof($matches);

			foreach($matches as $key => $value){
				if(intval($matches[$key][1]) <= $propertiesize){
					$paramList[] = $this->properties[intval($matches[$key][1])];
				}
			}
			if($paramsize > $propertiesize){
				for($i=0;$i<$paramsize-$propertiesize;$i++){
					$paramList[] = "";
				}
			}
			$message	= preg_replace("/\{[\d]+\}/","%s",$message);
			$message	= vsprintf($message,$paramList);
		}
		return $message;
	}
	function getDetail(){
		return sprintf("%s [%s:%d]\n%s\n",$this->getMessage(),$this->target["file"],$this->target["line"],date("Y/m/d H:i:s"));
	}
}
?>