<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.8.5
 */
class Rhaco{
	function define($defineName,$value=""){
		if(!defined($defineName)){
			define($defineName,$value);
		}
		return constant($defineName);
	}
	function path($fileName=""){
		$context = "";

		if(preg_match("/^\/.+/",$fileName)){
			$fileName = substr($fileName,1);
		}
		if(defined("CONTEXT_PATH")){
			$context = constant("CONTEXT_PATH");
		}
		return sprintf("%s%s",$context,$fileName);
	}
	function url($url=""){
		$path = $_SERVER["HTTP_HOST"];
		
		if(preg_match("/\/([^\/])\/.+/",$_SERVER["REDIRECT_URL"],$null)){
			$path .= "/".$null[1];
		}
		return sprintf("%s%s",Rhaco::_pathnormalize(Rhaco::define("CONTEXT_URL",$path)),Rhaco::_urlnormalize($url));
	}
	function resource($resourceFileName){
		$resourceFileName = str_replace("\\","/",$resourceFileName);

		if(substr($resourceFileName,0,1) != "/"){
			$resourceFileName = sprintf("/%s",$resourceFileName);
		}
		return Rhaco::path(sprintf("resources%s",$resourceFileName));
	}
	function templatepath($fileName=""){
		$path = Rhaco::define("TEMPLATE_PATH");

		if(preg_match("/^\/.+/",$fileName)){
			$fileName = substr($fileName,1);
		}
		return sprintf("%s%s",$path,$fileName);
	}
	function templateurl($url=""){
		return sprintf("%s%s",Rhaco::_pathnormalize(Rhaco::url("resources/templates")),Rhaco::_urlnormalize($url));
	}
	function import($rhacoClassName){
		return require_once(Rhaco::_phppathnormalize(Rhaco::define("RHACO_DIR"),$rhacoClassName));
	}
	function importLibrary($fileName){
		$path = Rhaco::path("library/");

		if(defined("LIBRARY_PATH")){
			$path = Rhaco::define("LIBRARY_PATH");
		}
		return require_once(Rhaco::_phppathnormalize($path,$fileName));
	}
	function loadLibrary($fileName){
		$path = Rhaco::path("library/");

		if(defined("LIBRARY_PATH") && !empty($fileName)){
			$path = Rhaco::define("LIBRARY_PATH");
		}
		return require(Rhaco::_phppathnormalize($path,$fileName));
	}
	function rhacoresource($resourceFileName){
		return FileUtil::getFilePath(Rhaco::define("RHACO_DIR"),sprintf("resources/%s",$resourceFileName));
	}
	function setupErrorMessage(){
		Rhaco::import("resources.Message");
		return Message::_("It cannot perform with the same path as rhaco.");
	}
	function version(){
		return "0.8.5";
	}
	function _phppathnormalize($path,$fileName){
		if(preg_match("/^(.+)\.php$/",$fileName,$null)){
			$fileName = $null[1];
		}
		return sprintf("%s%s.php",$path,str_replace(".","/",$fileName));
	}
	function _pathnormalize($path){
		if(preg_match("/[^\/]$/",$path,$null)){
			$path = $path."/";
		}
		return $path;
	}
	function _urlnormalize($url){
		if(preg_match("/^\/.+/",$url)){
			$url = substr($url,1);
		}
		return $url;
	}
}
?>
<?php
if(!defined("RHACO_DIR")){		
	Rhaco::define("RHACO_DIR",Rhaco::_pathnormalize(dirname(__FILE__)));
	Rhaco::import("resources.Message");
	Rhaco::import("util.Logger");	
	Message::loadRhacoMessages();
	
	$logger = new Logger();
	register_shutdown_function(array($logger,'flush'));	
}
?>